# Deep Research Skill - Design Document

Created: 2026-01-10

## Overview

A fully autonomous multi-agent research system that analyzes queries, dispatches parallel research agents, stores findings to files, and synthesizes results into actionable briefs or structured reports.

## Requirements

### Use Cases
- **Technical research** - Libraries, APIs, architectural patterns, debugging
- **Domain knowledge** - Topics, market research, competitive analysis
- **Hybrid** - Technical implementation of domain concepts

### Output Format
- Flexible between structured reports and actionable briefs
- Determined automatically based on query complexity and findings

### Depth Control
- Fully autonomous - agent makes all depth decisions
- No user checkpoints during research

### Source Strategy
- **Exa-primary** - Default to semantic search over standard web search
- **Source-adaptive** - Agent determines best sources based on query type
- Use exa-search skill to guide source selection

### Parallelism
- **Query-dependent** scaling
- Simple queries: 2-3 agents
- Complex queries: 5-6 agents

## Architecture

### Three-Phase Design

```
PHASE 1: PLANNING
┌─────────────────────────────────────────────────────────────────┐
│ Query Analyzer Agent                                            │
│ - Classify query type (technical/domain/hybrid)                 │
│ - Assess complexity → determine agent count                     │
│ - Decompose into research threads                               │
│ - Output: research-plan.md                                      │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
PHASE 2: PARALLEL RESEARCH
┌─────────────────────────────────────────────────────────────────┐
│ Research Agents (2-6 in parallel)                               │
│ - Each assigned specific thread                                 │
│ - Use exa-search skill for source strategy                      │
│ - Write findings to findings-{thread}.md                        │
│ - Operate independently, no cross-communication                 │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
PHASE 3: SYNTHESIS
┌─────────────────────────────────────────────────────────────────┐
│ Synthesizer Agent                                               │
│ - Reads all findings files                                      │
│ - Resolves conflicts, identifies gaps                           │
│ - Determines output format (brief vs report)                    │
│ - Writes final-output.md                                        │
└─────────────────────────────────────────────────────────────────┘
```

### Query Classification

| Query Type | Signals | Primary Sources |
|------------|---------|-----------------|
| Technical | APIs, libraries, code, architecture | `mcp__exa__get_code_context_exa` |
| Domain | Market, trends, concepts, comparisons | `mcp__exa__web_search_exa`, `yt-transcribe` |
| Hybrid | Technical implementation of domain concept | Both |

### Complexity → Agent Count

| Complexity | Indicators | Agents |
|------------|------------|--------|
| Simple | Single concept, narrow scope | 2-3 |
| Moderate | Multiple related concepts | 3-4 |
| Complex | Multi-faceted, cross-domain | 5-6 |

### Source Selection Logic

| Signal | Source |
|--------|--------|
| Code patterns, API usage, library docs | `mcp__exa__get_code_context_exa` |
| Conceptual understanding | `mcp__exa__web_search_exa` |
| Expert opinions, analysis | `mcp__exa__web_search_exa` (blogs, articles) |
| Video tutorials, talks | `yt-transcribe` when written sources insufficient |
| Very recent events (< 1 week) | `WebSearch` fallback |
| Specific known URL | `WebFetch` |

### Output Format Decision

| Condition | Format |
|-----------|--------|
| Simple query + clear consensus | Actionable Brief (~200-500 words) |
| Complex query OR conflicts OR multi-faceted | Structured Report (~1000-3000 words) |

### File Structure

```
{scratchpad}/deep-research-{timestamp}/
├── research-plan.md
├── findings-thread-1.md
├── findings-thread-2.md
├── findings-thread-N.md
└── final-output.md
```

### Context Management

- Parent agent never loads raw search results (~90% context savings)
- Each research agent starts fresh (no pollution)
- Synthesizer reads curated findings, not raw data
- Files preserved for debugging/re-synthesis

## Integration

| Skill/Tool | Purpose | Used By |
|------------|---------|---------|
| `exa-search` | Source strategy guidance | Research Agents |
| `mcp__exa__web_search_exa` | Semantic web search (default) | Research Agents |
| `mcp__exa__get_code_context_exa` | Technical/code queries | Research Agents |
| `yt-transcribe` | Video content extraction | Research Agents |
| `WebSearch` | Recent news fallback | Research Agents |
| `WebFetch` | Known URLs | Research Agents |

## Error Handling

- Research agent fails → note gap, continue with others
- Synthesizer finds critical gaps → flag in output, don't block
- All findings preserved in files
