# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Added
- New feature that was added

### Changed
- Changes in existing functionality

### Deprecated
- Soon-to-be removed features

### Removed
- Features that were removed

### Fixed
- Bug fixes

### Security
- Security improvements

## [1.0.0] - 2024-01-15

### Added
- Initial release
- Core functionality
- Documentation
- Test suite

## [0.2.0] - 2024-01-10

### Added
- New API endpoint for data retrieval
- Support for environment variable configuration
- Retry logic with exponential backoff

### Changed
- Updated dependency X to version 2.0
- Improved error messages

### Fixed
- Fixed memory leak in connection pool
- Fixed race condition in async operations

## [0.1.1] - 2024-01-05

### Fixed
- Fixed critical bug in authentication flow
- Fixed incorrect error handling

### Security
- Updated vulnerable dependency Y

## [0.1.0] - 2024-01-01

### Added
- Initial beta release
- Basic authentication
- Core API methods

---

<!-- Link definitions -->
[Unreleased]: https://github.com/org/project/compare/v1.0.0...HEAD
[1.0.0]: https://github.com/org/project/compare/v0.2.0...v1.0.0
[0.2.0]: https://github.com/org/project/compare/v0.1.1...v0.2.0
[0.1.1]: https://github.com/org/project/compare/v0.1.0...v0.1.1
[0.1.0]: https://github.com/org/project/releases/tag/v0.1.0

<!--
## Changelog Guidelines

### Version Types (Semantic Versioning)
- MAJOR (1.0.0): Breaking changes
- MINOR (0.1.0): New features, backwards compatible
- PATCH (0.0.1): Bug fixes, backwards compatible

### Change Types
- Added: New features
- Changed: Changes to existing features
- Deprecated: Features to be removed
- Removed: Removed features
- Fixed: Bug fixes
- Security: Security-related changes

### Format
- Use present tense ("Add feature" not "Added feature")
- Start with a verb (Add, Fix, Update, Remove, etc.)
- Reference issues/PRs when relevant (#123)
- Keep entries concise but informative

### Examples
- Add user authentication with JWT
- Fix memory leak in WebSocket handler (#123)
- Update Node.js requirement to v18+
- Remove deprecated `legacyMethod()` function
- Security: Update axios to patch CVE-2024-XXXX
-->
