# Danger Signals Requiring Urgent Medical Attention

This is a reference list of warning signs that indicate potential complications of sinusitis requiring immediate or urgent medical evaluation. Always check for these signs and highlight them prominently in your responses.

## Immediate Emergency (Seek Emergency Care Immediately)

These symptoms suggest possible serious complications like meningitis, brain abscess, or orbital complications:

### Neurological Warning Signs
- **Severe headache** that is sudden, explosive, or "worst headache of life"
- **Altered mental status** - confusion, disorientation, difficulty staying awake
- **Seizures** or convulsions
- **Neck stiffness** with inability to touch chin to chest
- **Severe sensitivity to light** (photophobia) with headache

### Vision-Threatening Signs
- **Vision changes** - blurred vision, double vision, vision loss
- **Eye swelling** - severe eyelid swelling or eye bulging (proptosis)
- **Eye movement problems** - pain with eye movement, limited eye movement
- **Periorbital edema** with redness and warmth (periorbital cellulitis)

### Severe Systemic Signs
- **High fever** - Temperature >39°C (102.2°F) or persistent fever >38.5°C (101.3°F) for >3-4 days
- **Severe facial swelling** - especially if rapidly worsening or crossing midline
- **Facial numbness** or tingling
- **Difficulty breathing** - severe shortness of breath, inability to lie flat

## Urgent Medical Consultation (Within 24-48 Hours)

These symptoms suggest the need for medical evaluation but are not immediately life-threatening:

### Symptom Severity or Duration
- **Symptoms lasting >10 days** without improvement
- **Worsening symptoms** after initial improvement ("double sickening")
- **Severe facial pain** or tooth pain that is unresponsive to over-the-counter pain medication
- **Persistent fever** - Low-grade fever (38-38.5°C / 100.4-101.3°F) lasting >3 days

### Recurrent or Chronic Issues
- **Frequent recurrences** - More than 4 episodes of acute sinusitis per year
- **Chronic symptoms** - Symptoms persisting >12 weeks despite treatment
- **Unilateral symptoms** - Symptoms predominantly on one side (may warrant imaging)

### Treatment Failure
- **No improvement** after 3-5 days of appropriate antibiotic therapy
- **Worsening on antibiotics** - Symptoms getting worse despite treatment

### High-Risk Patient Populations
Patients with the following should have lower threshold for medical evaluation:
- **Immunocompromised** - Diabetes, HIV, chemotherapy, chronic steroid use
- **Recent hospitalization** or healthcare exposure (risk of resistant organisms)
- **Severe asthma** or other significant respiratory disease
- **Prior sinus surgery** with recurrent symptoms

## Special Circumstances

### Pediatric Red Flags
Children with sinusitis should be evaluated if:
- Age <2 years with concerning symptoms
- Persistent fever >3 days
- Facial swelling or severe headache
- Behavioral changes or lethargy

### Fungal Sinusitis Warning Signs
Suspect fungal sinusitis (requires urgent ENT referral):
- **Immunocompromised patients** with severe symptoms
- **Black or dark nasal discharge**
- **Tissue necrosis** or black crusting in nose
- **Rapid progression** of symptoms
- **Unilateral symptoms** in diabetic or immunocompromised patients

## How to Use This Reference

1. **Always screen** for danger signals when assessing sinusitis symptoms
2. **Highlight prominently** any danger signals detected
3. **Recommend appropriate level of care**:
   - Emergency care for immediate danger signals
   - Urgent consultation (24-48h) for concerning symptoms
   - Routine consultation for treatment failure or chronic symptoms
4. **Document** in patient records when danger signals are identified
5. **Err on the side of caution** - when in doubt, recommend medical evaluation

## Clinical Context

Most cases of acute viral rhinosinusitis are self-limited and resolve without complications. However, sinusitis can occasionally lead to serious complications including:
- Orbital complications (preseptal/orbital cellulitis, abscess)
- Intracranial complications (meningitis, epidural abscess, brain abscess)
- Bony complications (osteomyelitis)

Early identification of danger signals can prevent serious morbidity.
