# Medical Disclaimer

This disclaimer should be included at the end of **every** sinusitis consultation response. You can adapt the wording slightly to fit the context, but always include the core message.

## Standard Disclaimer Template

```
⚠️ **Medical Disclaimer**: This information is provided for educational purposes only and is not intended to replace professional medical advice, diagnosis, or treatment. Always seek the advice of your physician or other qualified health provider with any questions you may have regarding a medical condition. Never disregard professional medical advice or delay in seeking it because of something you have read here. If you think you may have a medical emergency, call your doctor or emergency services immediately.
```

## Shorter Version (For Simple Queries)

```
⚠️ **Disclaimer**: This information is for educational purposes only and does not replace professional medical advice. Please consult your healthcare provider for personalized medical guidance.
```

## Context-Specific Variations

### When Recommending Medical Consultation
```
⚠️ **Important**: Based on your symptoms, I recommend consulting a healthcare provider [timeframe]. This information is for educational purposes only and does not replace professional medical evaluation and treatment.
```

### When Discussing Medications
```
⚠️ **Medical Disclaimer**: This information about medications is for educational purposes only. Specific medication choices, dosages, and treatment plans must be determined by your healthcare provider based on your individual medical history and current condition. Never start or stop medications without consulting your doctor.
```

### When Identifying Danger Signals
```
⚠️ **Urgent**: The symptoms you describe may indicate a serious complication requiring immediate medical attention. Please seek [emergency care / medical consultation within 24 hours] as appropriate. This is not a substitute for emergency medical services.
```

## Legal and Ethical Considerations

### Why the Disclaimer is Essential
1. **Legal protection** - Establishes that advice is educational, not diagnostic
2. **Patient safety** - Reminds users to seek professional care
3. **Scope limitation** - Clarifies the boundaries of AI assistance
4. **Liability reduction** - Reduces risk of medical liability

### Key Points to Always Include
- Information is **educational only**
- Does **not replace** professional medical advice
- Users should **consult their healthcare provider**
- **Never delay** seeking medical care based on this information

### What NOT to Do
- ❌ Provide specific drug dosages
- ❌ Make definitive diagnoses
- ❌ Recommend delaying medical care
- ❌ Override physician recommendations
- ❌ Claim to replace medical professionals

## Integration into Responses

### Placement
- **End of response** - Always the final element
- **After recommendations** - After all advice has been given
- **Before sign-off** - Last thing the user reads

### Formatting
- Use warning emoji (⚠️) or similar visual indicator
- **Bold** the term "Medical Disclaimer" or "Disclaimer"
- Consider using a horizontal rule (---) before the disclaimer to set it apart

### Consistency
- Include in **every response** that provides medical information
- Adapt wording to context but maintain core message
- Don't skip it even for "simple" questions - consistency is important

## Example Integration

```
[Your medical advice and recommendations here...]

---

⚠️ **Medical Disclaimer**: This information is provided for educational purposes only and is not intended to replace professional medical advice, diagnosis, or treatment. Always consult your healthcare provider regarding any medical concerns.
```
