---
name: polish
description: This skill should be used when polishing academic research paper text for grammar, clarity, fluency, and natural phrasing. Specifically designed for non-native English speakers writing for top-tier computer science conferences.
---

# Academic Text Polish

Rewrite and refine research paper text to improve grammar, clarity, fluency, and academic style while preserving technical accuracy and LaTeX integrity.

## When to Use This Skill

- Polishing research paper text for conference submissions
- Improving grammar and sentence structure
- Enhancing fluency and natural phrasing for non-native speakers
- Refining technical writing for clarity and precision
- Preparing text for top-tier CS conferences (OSDI, NSDI, SOSP, SIGCOMM)

## Core Principles

Apply these principles in order of priority:

1. **Clarity and Precision**: Prioritize clear, unambiguous, and precise language for technical audiences
2. **Fluency**: Ensure natural flow and smooth readability
3. **Appropriate Vocabulary**: Use terminology common in technical and systems research papers
4. **Logical Cohesion**: Assess and improve logical flow and argument structure
5. **LaTeX Integrity**: Respect original LaTeX syntax - only modify textual content within commands/environments

## Writing Constraints

### Hyphen Usage
- **Avoid hyphens for connecting independent clauses**
- Bad: "The system is fast - it processes data quickly"
- Good: "The system is fast, processing data quickly"
- Exception: Compound adjectives (e.g., "state-of-the-art") are acceptable

### Voice Preference
- **Prefer active voice** for directness and clarity
- Preferred: "We implemented the prototype"
- Avoid: "The prototype was implemented by us"
- Use passive voice judiciously when the object is more important than the actor

### Tense Guidelines
- **Present tense** for the author's work: "We implement a prototype..."
- **Past tense** for previous literature: "Smith et al. proposed..."

### Acronym Handling
- **Define on first use**: "Network Address Translation (NAT) is widely used. NAT helps..."
- Use short form thereafter

### Conciseness
- Eliminate redundancy without sacrificing clarity
- Be cautious about adding details - conference papers have strict page limits
- Remove unnecessary words and phrases

## Target Audience

Graduate students, professors, and researchers in computer science. Write naturally for this technical audience without oversimplification.

## Polishing Goals

Rewrite the text to achieve:

1. **Correct grammatical errors** (subject-verb agreement, articles, prepositions, etc.)
2. **Improve sentence structure** for clarity, conciseness, and flow
3. **Ensure precise word choices** appropriate for academic systems research
4. **Enhance readability and fluency** for natural reading
5. **Maintain formal, objective, academic tone** throughout
6. **Identify potential logical gaps** that might need substantiation

## Output Requirements

### Revised Text
Provide the polished version of the text

### Change Justification
Explain each significant change with clear reasoning:
- Example: "Replaced 'got bigger' with 'increased' for formality"
- Example: "Restructured sentence for better subject-verb agreement"
- Example: "Combined sentences to improve flow"
- Example: "Changed to active voice for directness"

### Optional: No Changes Needed
If the text is already well-written, state "No significant improvements needed" rather than making pedantic suggestions

## Important Guidelines

- **Aim for conference acceptance, not perfection**
- Provide no advice when no meaningful improvement can be made
- Avoid pedantic or nit-picking changes
- Focus on significant improvements that enhance clarity or correctness
- Respect technical terminology and domain-specific phrasing
- Preserve the author's intended meaning and argument structure
