---
name: summary
description: This skill should be used when providing concise summaries of research paper text. Use for quickly understanding the core content, arguments, and contributions of paper sections targeting top-tier computer science conferences.
---

# Academic Text Summarizer

Generate concise summaries of research paper text that capture main arguments, key information, and primary takeaways while maintaining technical accuracy.

## When to Use This Skill

- Summarizing research paper sections for quick understanding
- Extracting core arguments and claims from dense technical text
- Creating concise overviews of paper contributions
- Understanding the main message of a paragraph or section
- Preparing summaries for paper reviews or presentations

## Summary Goals

Create a summary that captures:

1. **Main argument(s) or claims** being made
2. **Key pieces of information or evidence** presented
3. **Primary takeaway message** a reader should understand

## Summary Requirements

Follow these guidelines for effective summaries:

### Conciseness
- Focus on core content only
- Eliminate unnecessary details
- Keep summaries brief but complete

### Technical Accuracy
- Preserve precise technical terminology
- Maintain accuracy of claims and findings
- Do not oversimplify complex concepts

### Clarity
- Use clear, precise language
- Make the summary self-contained when possible
- Avoid ambiguous phrasing

### Content Focus
- Highlight key contributions or findings
- Emphasize novel aspects or important results
- Capture the "so what?" of the text

## Output Format

Provide the summary in two parts:

### 1. Summary
A concise paragraph (2-5 sentences typically) that captures the essential content.

### 2. Explanation
A brief explanation (1-2 sentences) of how the summary encapsulates the core message of the original text.

## Target Audience

Graduate students, professors, and researchers in computer science who need quick understanding of technical and systems research content.

## Example Structure

```
**Summary:**
[2-5 sentences capturing the main argument, key information, and primary takeaway]

**Explanation:**
[1-2 sentences explaining how this summary represents the core message]
```

## Guidelines for Different Text Types

### Abstract or Introduction
- Focus on problem statement, approach, and key results
- Highlight main contributions

### Related Work
- Capture how prior work relates to current paper
- Note key differences or gaps being addressed

### Methodology/Design
- Summarize core approach and key design decisions
- Highlight novel techniques or mechanisms

### Evaluation
- Focus on main findings and key results
- Note important performance characteristics

### Conclusion
- Capture main achievements and implications
- Note future directions if significant

## Important Constraints

- Maintain technical precision - do not dumb down
- Avoid editorializing or adding opinions
- Stay faithful to the original text's meaning
- Do not introduce information not in the source text
- Keep language appropriate for academic audience
