## API Reference

### Core shadcn/ui Operations
- `create_component(variant_config, props)` - Create new component
- `customize_theme(theme_config, colors)` - Customize theme
- `install_component(component_name)` - Install new component
- `setup_design_system(tokens, branding)` - Set up design system
- `optimize_components(performance_config)` - Optimize component performance

### Context7 Integration
- `get_latest_shadcn_docs()` - shadcn/ui docs via Context7
- `analyze_component_patterns()` - Component patterns via Context7
- `optimize_theme_system()` - Theme optimization via Context7

## Best Practices (November 2025)

### DO
- Use TypeScript for type safety and better developer experience
- Implement proper accessibility with ARIA attributes
- Customize themes using CSS variables for consistency
- Optimize component performance with memoization and lazy loading
- Use form validation with proper error handling
- Implement responsive design with Tailwind CSS
- Use Radix UI primitives for accessible components
- Test components across different browsers and devices

### DON'T
- Skip TypeScript type definitions and validations
- Ignore accessibility requirements and WCAG compliance
- Override component styles without understanding the CSS structure
- Forget to implement proper error handling and validation
- Skip performance optimization for large datasets
- Use inline styles instead of Tailwind CSS classes
- Forget to implement proper keyboard navigation
- Skip component testing and user experience validation

## Works Well With

- `moai-domain-frontend` (Frontend development patterns)
- `moai-baas-foundation` (Enterprise UI architecture)
- `moai-security-api` (UI security implementation)
- `moai-essentials-perf` (Performance optimization)
- `moai-foundation-trust` (Accessibility and compliance)
- `moai-domain-backend` (Backend integration)
- `moai-baas-vercel-ext` (Frontend deployment)
- `moai-domain-testing` (Component testing strategies)

## Changelog

- .0 (2025-11-13): Complete Enterprise rewrite with 40% content reduction, 4-layer Progressive Disclosure structure, Context7 integration, November 2025 shadcn/ui ecosystem updates, and advanced component patterns
- v2.0.0 (2025-11-11): Complete metadata structure, component patterns, theme system
- v1.0.0 (2025-11-11): Initial shadcn/ui component library

---

End of Skill | Updated 2025-11-13

## Design System Integration

### Enterprise Features
- Comprehensive component library with enterprise-grade features
- Advanced theming system with brand customization
- Performance optimization for large-scale applications
- Accessibility compliance with WCAG 2.1 AA standards

### Modern Development
- TypeScript-first development with full type safety
- Modern React patterns with hooks and server components
- Tailwind CSS integration for consistent styling
- Framer Motion for smooth animations and transitions

---

End of Enterprise shadcn/ui Component Library Expert
