# SVG Skill Modules

This directory contains detailed implementation guides for specific SVG topics.

## Module Index

### svg-basics.md

Covers foundational SVG concepts including document structure with svg, g, defs, use, and symbol elements. Explains the coordinate system, viewBox, and viewport relationships. Details all basic shapes including rect, circle, ellipse, line, polyline, and polygon. Comprehensive path command reference covering all movement, line, curve, and arc commands. Text element usage with text, tspan, and textPath.

### svg-styling.md

Comprehensive styling guide covering fill properties including color, opacity, and fill-rule. Stroke properties including width, linecap, linejoin, dasharray, and dashoffset. Linear and radial gradients with stop elements and spread methods. Pattern creation for repeating textures. Clipping with clipPath for hard edges. Masking with mask for soft transparency effects. Introduction to filter primitives.

### svg-optimization.md

Performance optimization guide covering SVGO installation and CLI usage. Configuration file setup with svgo.config.mjs. Plugin customization for specific optimization needs. Preserving IDs, viewBox, and accessibility elements. SVGZ compression for additional size reduction. Icon sprite techniques for efficient delivery. Performance best practices for web and mobile.

### svg-animation.md

Animation techniques covering CSS animations and transitions for SVG elements. Transform-origin and keyframe patterns. SMIL animation elements including animate, animateTransform, animateMotion, and set. JavaScript animation with requestAnimationFrame. Interaction patterns for hover, click, and drag. Performance considerations for smooth animations. Cross-browser compatibility notes.

## Usage

These modules are loaded on-demand when working with specific SVG topics. Reference them from SKILL.md for detailed implementation patterns.

## Related Resources

- SKILL.md: Quick reference and implementation overview
- reference.md: Complete API reference for SVG elements and attributes
- examples.md: Working code examples for common patterns
