# ida_name

Name management - getting, setting, validating, and demangling names at addresses.

## Key Functions

### Getting Names
- `get_name(ea)` - Get name at address (simple form)
- `get_colored_name(ea)` - Get name with color tags
- `get_ea_name(ea, gtn_flags=0)` - Get name with flags (alias for get_name with flags)
- `get_visible_name(ea, gtn_flags=0)` - Get visible name (respects hidden status)
- `get_short_name(ea, gtn_flags=0)` - Get short form name
- `get_long_name(ea, gtn_flags=0)` - Get long form name
- `get_colored_short_name(ea, gtn_flags=0)` - Colored short name
- `get_colored_long_name(ea, gtn_flags=0)` - Colored long name

### Setting Names
- `set_name(ea, name, flags=0)` - Set or delete name at address
- `force_name(ea, name, flags=0)` - Force name (add suffix if needed)
- `del_global_name(ea)` - Delete global name
- `del_local_name(ea)` - Delete local name
- `set_dummy_name(from_ea, ea)` - Generate autogenerated dummy name (loc_, sub_, etc.)
- `make_name_auto(ea)` - Mark name as autogenerated
- `make_name_user(ea)` - Mark name as user-defined
- `make_name_public(ea)` - Make name public
- `make_name_non_public(ea)` - Make name non-public
- `make_name_weak(ea)` - Make name weak
- `make_name_non_weak(ea)` - Make name non-weak

### Name Lookup
- `get_name_ea(from_ea, name)` - Get address for name (search from address)
- `get_name_base_ea(from_ea, to_ea)` - Get base address for name
- `get_name_value(from_ea, name)` - Get name value

### Name Visibility
- `hide_name(ea)` - Hide name from display
- `show_name(ea)` - Show previously hidden name

### Name Validation
- `is_valid_cp(cp, kind, data=None)` - Check if codepoint is valid for name type
- `is_ident_cp(cp)` - Check if codepoint is valid identifier character
- `is_strlit_cp(cp, ranges=None)` - Check if valid in string literal
- `is_visible_cp(cp)` - Check if codepoint is visible
- `is_ident(name)` - Check if valid identifier
- `is_uname(name)` - Check if valid user name
- `is_valid_typename(name)` - Check if valid type name
- `validate_name(name, type, flags=1)` - Validate name for type with flags
- `cleanup_name(ea, name, flags=0)` - Clean up name (remove invalid chars)
- `extract_name(line, x)` - Extract name from line at position

### Name List
- `get_nlist_size()` - Get name list size
- `get_nlist_idx(ea)` - Get index in name list
- `is_in_nlist(ea)` - Check if address is in name list
- `get_nlist_ea(idx)` - Get address at name list index
- `get_nlist_name(idx)` - Get name at name list index
- `rebuild_nlist()` - Rebuild name list
- `reorder_dummy_names()` - Reorder dummy names

### Debug Names
- `set_debug_name(ea, name)` - Set debug name (from debug info)
- `get_debug_name(ea_ptr, how)` - Get debug name with transform
- `del_debug_names(ea1, ea2)` - Delete debug names in range
- `get_debug_name_ea(name)` - Get address for debug name
- `get_debug_names(...)` - Get all debug names
- `is_name_defined_locally(...)` - Check if name is locally defined

### Name Demangling
- `demangle_name(name, disable_mask, demreq=DQT_FULL)` - Demangle C++ name
- `get_demangled_name(ea, inhibitor, demform, gtn_flags=0)` - Get demangled name at address
- `get_mangled_name_type(name)` - Get mangled name type (CODE, DATA, UNKNOWN)

### Utility
- `calc_gtn_flags(fromaddr, ea)` - Calculate get name flags
- `set_cp_validity(...)` / `get_cp_validity(...)` - Set/get codepoint validity

## Key Flags

### Set Name Flags (SN_*)
- `SN_CHECK` - Fail if name contains invalid characters
- `SN_NOCHECK` - Replace invalid characters silently with '_'
- `SN_PUBLIC` / `SN_NON_PUBLIC` - Make public/non-public
- `SN_WEAK` / `SN_NON_WEAK` - Make weak/non-weak
- `SN_AUTO` / `SN_NON_AUTO` - Make autogenerated/non-autogenerated
- `SN_NOLIST` - Exclude from name list
- `SN_NOWARN` - Don't display warning if failed
- `SN_LOCAL` - Create local name (requires function context)
- `SN_IDBENC` - Name is in IDB encoding
- `SN_FORCE` - Add numerical suffix if name exists (_123)
- `SN_NODUMMY` - Prepend '_' if name begins with dummy suffix
- `SN_DELTAIL` - Delete hindering item if tail byte conflicts
- `SN_MULTI` - Add as alternative name comment if name exists
- `SN_MULTI_FORCE` - Replace name, move old to comment

### Get Name Flags (GN_*)
- `GN_VISIBLE` - Get visible name
- `GN_COLORED` - Include color tags
- `GN_DEMANGLED` - Get demangled name
- `GN_STRICT` - Strict name lookup
- `GN_SHORT` - Short form
- `GN_LONG` - Long form
- `GN_LOCAL` - Include local names
- `GN_ISRET` / `GN_NOT_ISRET` - Is/isn't return value
- `GN_NOT_DUMMY` - Exclude dummy names

### Get Name Ex Flags (GETN_*)
- `GETN_APPZERO` - Append zero to result
- `GETN_NOFIXUP` - Don't apply fixups
- `GETN_NODUMMY` - Don't return dummy names

### Get Near Comment Flags (GNCN_*)
- `GNCN_NOSEG` - Don't include segment name
- `GNCN_NOCOLOR` - No color tags
- `GNCN_NOLABEL` - Don't include label
- `GNCN_NOFUNC` - Don't include function name
- `GNCN_SEG_FUNC` - Include segment and function
- `GNCN_SEGNUM` - Include segment number
- `GNCN_REQFUNC` - Require function
- `GNCN_REQNAME` - Require name
- `GNCN_NODBGNM` - No debug names
- `GNCN_PREFDBG` - Prefer debug names

### Debug Name Flags (DEBNAME_*)
- `DEBNAME_EXACT` - Exact match
- `DEBNAME_LOWER` - Convert to lowercase
- `DEBNAME_UPPER` - Convert to uppercase
- `DEBNAME_NICE` - Nice formatting

### Demangling Flags (DQT_*)
- `DQT_FULL` - Full demangling
- `DQT_NAME_TYPE` - Name and type only
- `DQT_COMPILER` - Compiler-specific
- `DQT_NPURGED_2` / `DQT_NPURGED_4` / `DQT_NPURGED_8` - Number of purged bytes

### Name Types (NT_*)
- `NT_NONE` - No name
- `NT_BYTE` - Byte name
- `NT_LOCAL` - Local name
- `NT_STKVAR` - Stack variable
- `NT_ENUM` - Enum member
- `NT_ABS` - Absolute symbol
- `NT_SEG` - Segment
- `NT_STROFF` - Structure offset
- `NT_BMASK` - Bitmask
- `NT_REGVAR` - Register variable

### Validate Name Types (VNT_*)
- `VNT_IDENT` - Identifier
- `VNT_TYPE` - Type name
- `VNT_UDTMEM` - User-defined type member
- `VNT_STRLIT` - String literal
- `VNT_VISIBLE` - Visible name

### Cleanup Name Flags (CN_*)
- `CN_KEEP_TRAILING_DIGITS` - Keep trailing digits
- `CN_KEEP_UNDERSCORES` - Keep underscores

### Mangling Flags (MNG_*)
Extensive demangling control: MNG_NOTYPE, MNG_NORETTYPE, MNG_NOBASEDT, MNG_NOCALLC, MNG_NOTHROW, MNG_SHORT_FORM, MNG_LONG_FORM, etc.

### Calling Conventions (MT_*)
- `MT_CDECL` / `MT_PASCAL` / `MT_STDCALL` / `MT_FASTCALL` / `MT_THISCALL` / `MT_VECTORCALL` / `MT_REGCALL` - Calling conventions
- `MT_SYSCALL` / `MT_INTERRUPT` - Special conventions

### Compilers (MT_*)
- `MT_MSCOMP` - Microsoft compiler
- `MT_BORLAN` - Borland compiler
- `MT_WATCOM` - Watcom compiler
- `MT_GNU` / `MT_GCC3` - GNU/GCC compilers
- `MT_OTHER` - Other compiler

## Classes

### ea_name_t
Address-name pair.

### ea_name_vec_t
Vector of ea_name_t.

### NearestName
Nearest name helper class.

## Constants

- `MAXNAMELEN` - Maximum name length (including terminator)
- `FUNC_IMPORT_PREFIX` - Import function prefix
- `MANGLED_CODE` / `MANGLED_DATA` / `MANGLED_UNKNOWN` - Mangled name types
- Various ignore flags: `ignore_none`, `ignore_regvar`, `ignore_llabel`, `ignore_stkvar`, `ignore_glabel`

## See Also
Full docs: skill/docs/ida_name.rst
