# Report Templates

## Markdown Report Template

```markdown
# Security Audit Report

**Project:** [PROJECT_NAME]  
**Date:** [TIMESTAMP]  
**Auditor:** Claude Security Audit Skill  
**Version:** 1.0

---

## Executive Summary

### Overview
[Brief description of what was audited]

### Key Findings
| Severity | Count |
|----------|-------|
| 🔴 Critical | X |
| 🟠 High | X |
| 🟡 Medium | X |
| 🟢 Low | X |
| **Total** | **X** |

### Top Risks
1. [Most critical finding - one sentence]
2. [Second most critical - one sentence]
3. [Third most critical - one sentence]

### Risk Rating
**Overall Risk Level:** [Critical/High/Medium/Low]

---

## Scope

### Included
- [List of directories/files scanned]

### Excluded
- node_modules/, vendor/, dist/, build/
- Test files
- Documentation

### Technologies Identified
- **Language:** [Primary language]
- **Framework:** [Framework name]
- **Database:** [Database type]

---

## Detailed Findings

### VULN-001: [Vulnerability Title]

| Attribute | Value |
|-----------|-------|
| **Severity** | Critical |
| **CWE** | CWE-XXX |
| **CVSS** | X.X |
| **Location** | `path/to/file.js:123` |
| **Status** | Confirmed |

#### Description
[Detailed explanation of the vulnerability]

#### Vulnerable Code
```[language]
// File: path/to/file.js
// Lines: 120-130
[vulnerable code snippet]
```

#### Proof of Concept
[Steps to reproduce or exploit]

#### Impact
[What an attacker could achieve]

#### Recommendation
[How to fix with code example]

```[language]
// Secure implementation
[fixed code]
```

#### References
- [Link to CWE]
- [Link to relevant documentation]

---

[Repeat for each vulnerability]

---

## Recommendations Summary

### Immediate Actions (Critical/High)
1. [ ] [Action item 1]
2. [ ] [Action item 2]

### Short-term Actions (Medium)
1. [ ] [Action item 3]
2. [ ] [Action item 4]

### Long-term Improvements (Low)
1. [ ] [Action item 5]
2. [ ] [Action item 6]

---

## Appendix

### A. Files Analyzed
[List of files or count]

### B. Tools Used
- Claude Security Audit Skill
- Manual code review

### C. Methodology
- Architecture assessment
- STRIDE threat modeling
- Manual code review
- Vulnerability validation

---

*Report generated by Claude Security Audit Skill*
```

---

## JSON Report Schema

```json
{
  "$schema": "http://json-schema.org/draft-07/schema#",
  "type": "object",
  "properties": {
    "metadata": {
      "type": "object",
      "properties": {
        "project": { "type": "string" },
        "generated": { "type": "string", "format": "date-time" },
        "version": { "type": "string" },
        "scan_duration_seconds": { "type": "number" },
        "files_analyzed": { "type": "integer" }
      }
    },
    "summary": {
      "type": "object",
      "properties": {
        "total_vulnerabilities": { "type": "integer" },
        "by_severity": {
          "type": "object",
          "properties": {
            "critical": { "type": "integer" },
            "high": { "type": "integer" },
            "medium": { "type": "integer" },
            "low": { "type": "integer" }
          }
        },
        "overall_risk": { 
          "type": "string",
          "enum": ["critical", "high", "medium", "low"]
        }
      }
    },
    "vulnerabilities": {
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "id": { "type": "string" },
          "title": { "type": "string" },
          "severity": { 
            "type": "string",
            "enum": ["critical", "high", "medium", "low"]
          },
          "cwe_id": { "type": "string" },
          "cvss_score": { "type": "number" },
          "file_path": { "type": "string" },
          "line_number": { "type": "integer" },
          "code_snippet": { "type": "string" },
          "description": { "type": "string" },
          "evidence": { "type": "string" },
          "impact": { "type": "string" },
          "recommendation": { "type": "string" },
          "references": {
            "type": "array",
            "items": { "type": "string" }
          },
          "exploitability": {
            "type": "string",
            "enum": ["confirmed", "likely", "possible"]
          }
        },
        "required": ["id", "title", "severity", "file_path", "description"]
      }
    },
    "technologies": {
      "type": "object",
      "properties": {
        "languages": { "type": "array", "items": { "type": "string" } },
        "frameworks": { "type": "array", "items": { "type": "string" } },
        "databases": { "type": "array", "items": { "type": "string" } }
      }
    }
  }
}
```

---

## Example JSON Output

```json
{
  "metadata": {
    "project": "example-app",
    "generated": "2025-01-15T10:30:00Z",
    "version": "1.0.0",
    "scan_duration_seconds": 127,
    "files_analyzed": 234
  },
  "summary": {
    "total_vulnerabilities": 8,
    "by_severity": {
      "critical": 1,
      "high": 3,
      "medium": 3,
      "low": 1
    },
    "overall_risk": "high"
  },
  "vulnerabilities": [
    {
      "id": "VULN-001",
      "title": "SQL Injection in User Authentication",
      "severity": "critical",
      "cwe_id": "CWE-89",
      "cvss_score": 9.8,
      "file_path": "src/controllers/auth.js",
      "line_number": 45,
      "code_snippet": "const query = `SELECT * FROM users WHERE email = '${email}'`;",
      "description": "User-supplied email is directly concatenated into SQL query without sanitization, allowing SQL injection attacks.",
      "evidence": "The email parameter from req.body is used directly in string interpolation at line 45. No input validation or parameterized query is used.",
      "impact": "Attacker can bypass authentication, extract all user data, or potentially gain database admin access.",
      "recommendation": "Use parameterized queries: db.query('SELECT * FROM users WHERE email = ?', [email])",
      "references": [
        "https://cwe.mitre.org/data/definitions/89.html",
        "https://owasp.org/www-community/attacks/SQL_Injection"
      ],
      "exploitability": "confirmed"
    }
  ],
  "technologies": {
    "languages": ["JavaScript", "TypeScript"],
    "frameworks": ["Express.js", "React"],
    "databases": ["PostgreSQL"]
  }
}
```

---

## Bug Bounty Report Template

For submitting findings to bug bounty programs:

```markdown
## Summary
[One sentence describing the vulnerability]

## Severity
[Critical/High/Medium/Low] - CVSS: X.X

## Vulnerability Type
[CWE-XXX: Name]

## Description
[Detailed technical description]

## Steps to Reproduce
1. [Step 1]
2. [Step 2]
3. [Step 3]

## Proof of Concept
[Code, screenshots, or video demonstrating the issue]

```
[Request/response examples]
```

## Impact
[What an attacker could achieve with this vulnerability]

## Affected Endpoint/Component
- **URL:** [endpoint]
- **File:** [if applicable]
- **Parameter:** [vulnerable parameter]

## Suggested Fix
[How to remediate the issue]

## References
- [Relevant documentation]
- [Similar CVEs if applicable]
```

---

## SARIF Format (for CI/CD integration)

```json
{
  "$schema": "https://raw.githubusercontent.com/oasis-tcs/sarif-spec/master/Schemata/sarif-schema-2.1.0.json",
  "version": "2.1.0",
  "runs": [
    {
      "tool": {
        "driver": {
          "name": "Claude Security Audit",
          "version": "1.0.0",
          "informationUri": "https://claude.ai"
        }
      },
      "results": [
        {
          "ruleId": "CWE-89",
          "level": "error",
          "message": {
            "text": "SQL Injection vulnerability found"
          },
          "locations": [
            {
              "physicalLocation": {
                "artifactLocation": {
                  "uri": "src/controllers/auth.js"
                },
                "region": {
                  "startLine": 45
                }
              }
            }
          ]
        }
      ]
    }
  ]
}
```
