---
name: refactorer
description: "コード品質の問題を積極的に検出し改善する。以下を検出した際に自動発動: (1) 長いメソッド/クラス、(2) 重複コードパターン、(3) 深いネスト、(4) 不適切な命名、(5) マジックナンバー/文字列、(6) N+1 クエリパターン、(7) 未使用コード、(8) Feature Envy や God クラス。言語非依存のリファクタリングガイダンスを提供。"
---

# リファクタラー

コードスメルを検出し、適切なリファクタリングパターンを適用してコード品質を改善する。

## 前提(リファクタリングルール)

リファクタリング時の厳格なルール：

1. **前提条件**

   - すべてのテストが通っている状態でのみ開始
   - 動作変更とリファクタリングを混在させない

2. **実行手順**

   - 一度に一つの変更のみ
   - 各ステップ後に必ずテスト実行
   - 失敗したら即座に元に戻す

## ワークフロー

### 1. コードスメルの検出

以下の主要な指標をスキャンする:

| カテゴリ | 指標 |
|----------|------|
| **肥大化** | メソッド 20行超、クラス 200行超、パラメータ 4個超、プリミティブ偏重 |
| **構造** | ネスト 3段超、型による switch、重複コードブロック |
| **命名** | 略語、意図不明、規則の不統一 |
| **パフォーマンス** | N+1 クエリ、重複計算、不要なイテレーション |
| **結合** | メッセージチェーン、Feature Envy、不適切な密結合 |

### 2. 問題の優先順位付け

**高優先度**（最初に修正）:
- 重複コード
- N+1 クエリ / パフォーマンス問題
- God クラス / メソッド

**中優先度**:
- 不適切な命名
- 深いネスト
- マジックナンバー

**低優先度**（提案するが、ブロックしない）:
- 軽微な構造改善
- コードスタイルの一貫性

### 3. リファクタリングの適用

**ルール**:
1. 一度に1つのリファクタリングのみ実施
2. 変更ごとにテストを実行
3. 構造変更と動作変更を混在させない
4. テストが失敗したら即座に元に戻す

**よく使うパターン**（[references/refactoring-patterns.md](references/refactoring-patterns.md) 参照）:
- **メソッドの抽出**: 長いメソッド → 小さく焦点を絞ったメソッドへ
- **クラスの抽出**: God クラス → 単一責任のクラスへ
- **ガード節**: 深いネスト → 早期リターンへ
- **条件分岐のポリモーフィズムによる置換**: 型 switch → ポリモーフィックなディスパッチへ
- **パラメータオブジェクトの導入**: 多数のパラメータ → 値オブジェクトへ

### 4. 検証

- すべてのテストが通ること
- リンターから新しい警告が出ないこと
- コードがより読みやすくなっていること（短く、明確な名前、ネストが浅い）

## クイックリファレンス

| スメル | リファクタリング |
|--------|------------------|
| 長いメソッド | メソッドの抽出 |
| 大きなクラス | クラスの抽出 |
| 長いパラメータリスト | パラメータオブジェクトの導入 |
| 重複コード | メソッド/クラスの抽出 |
| 深いネスト | ガード節 |
| 型による switch | ポリモーフィズムによる置換 |
| マジックナンバー | 定数による置換 |
| Feature Envy | メソッドの移動 |
| メッセージチェーン | 委譲の隠蔽 |

## リソース

- [references/code-smells.md](references/code-smells.md) - コードスメル検出の詳細ガイド
- [references/refactoring-patterns.md](references/refactoring-patterns.md) - 例付きリファクタリングパターン集
