# コードスメル検出ガイド

## 目次

1. [肥大化（Bloaters）](#肥大化bloaters)
2. [オブジェクト指向の誤用](#オブジェクト指向の誤用)
3. [変更妨害](#変更妨害)
4. [不要なもの](#不要なもの)
5. [結合子](#結合子)

---

## 肥大化（Bloaters）

効果的に扱うには大きくなりすぎたコード。

### 長いメソッド

**検出方法**:
- メソッドが 20〜30 行を超える
- インデントが複数レベル（3段超）
- メソッド内の「セクション」を分けるコメント
- メソッド名を簡潔に付けるのが難しい

**推奨リファクタリング**: メソッドの抽出

### 大きなクラス

**検出方法**:
- インスタンス変数が多い（7〜10 個超）
- メソッドが多い（15〜20 個超）
- クラス名が曖昧（Manager、Processor、Handler）
- 異なるメソッドが異なるフィールドのサブセットを使用

**推奨リファクタリング**: クラスの抽出、サブクラスの抽出

### 長いパラメータリスト

**検出方法**:
- メソッドのパラメータが 3〜4 個を超える
- 複数のパラメータが常に一緒に渡される
- 動作を変える真偽値フラグ

**推奨リファクタリング**: パラメータオブジェクトの導入、パラメータのメソッド呼び出しによる置換

### プリミティブ偏重

**検出方法**:
- ドメイン概念にプリミティブ型を使用（電話番号に文字列、金額に整数）
- オブジェクトの代わりに配列/マップを使用
- 型コードや enum 的な定数

**例**:
```
// スメル: ドメイン概念にプリミティブを使用
function createUser(name, street, city, zip, phone) { ... }

// 改善: 値オブジェクトを使用
function createUser(name, address, phoneNumber) { ... }
```

**推奨リファクタリング**: プリミティブのオブジェクトによる置換、パラメータオブジェクトの導入

---

## オブジェクト指向の誤用

オブジェクト指向原則の誤った適用。

### switch 文

**検出方法**:
- 同じ switch/case や if/else チェーンが複数箇所にある
- 動作を決定する型コードに対する switch
- 新しい型を追加すると複数ファイルの変更が必要

**推奨リファクタリング**: 条件分岐のポリモーフィズムによる置換、型コードのサブクラスによる置換

### 継承拒否

**検出方法**:
- サブクラスが継承したメソッドのごく一部しか使わない
- サブクラスがメソッドをオーバーライドして何もしないか例外をスロー
- 「is-a」関係が論理的に成り立たない

**推奨リファクタリング**: 継承の委譲による置換

### 並行継承階層

**検出方法**:
- サブクラスを作ると別の場所で別のサブクラスも作る必要がある
- 2つの階層が互いをミラーリングしている
- クラスに一致するプレフィックス/サフィックスがある

**推奨リファクタリング**: メソッドの移動、フィールドの移動

---

## 変更妨害

変更を不必要に困難にするコード。

### 発散的変更

**検出方法**:
- 1つのクラスが多くの異なる理由で変更される
- 無関係な機能の変更が同じクラスに影響
- クラスが「God クラス」になっている

**推奨リファクタリング**: クラスの抽出、関心の分離

### 散弾銃手術

**検出方法**:
- 1つの変更が多くの異なるクラスの編集を必要とする
- 関連するロジックがコードベース全体に散らばっている
- 「すべてが壊れるかもしれない」という変更への恐怖

**推奨リファクタリング**: メソッドの移動、フィールドの移動、クラスのインライン化

### Feature Envy（機能への羨望）

**検出方法**:
- メソッドが自身のクラスより他のクラスの機能を多く使う
- 別のオブジェクトへの過度な getter 呼び出し
- データと操作が異なる場所にある

**例**:
```
// スメル: 顧客のデータを広範に使用
function calculateDiscount(customer) {
  if (customer.getPurchaseCount() > 10 &&
      customer.getTotalSpent() > 1000 &&
      customer.getMembershipYears() > 2) {
    return 0.15
  }
  return 0
}

// 改善: Customer クラスに移動
class Customer {
  calculateDiscount() {
    if (this.purchaseCount > 10 &&
        this.totalSpent > 1000 &&
        this.membershipYears > 2) {
      return 0.15
    }
    return 0
  }
}
```

**推奨リファクタリング**: メソッドの移動

---

## 不要なもの

削除できる無意味なコード。

### コメント（過剰）

**検出方法**:
- 「なぜ」ではなく「何を」を説明するコメント
- 不明瞭なコードを補うコメント
- コメントアウトされたコードが残っている
- 古くなった/間違ったコメント

**推奨リファクタリング**: メソッドの抽出（良い名前で）、名前の変更

### 重複コード

**検出方法**:
- コピーペーストされたコードブロック
- 軽微な違いのある類似アルゴリズム
- 同じ式が複数箇所で計算される

**推奨リファクタリング**: メソッドの抽出、クラスの抽出、メソッドの引き上げ

### デッドコード

**検出方法**:
- 到達不能なコードパス
- 未使用の変数、パラメータ、メソッド、クラス
- 「念のため」のコードで呼ばれないもの
- コメントアウトされたコード

**推奨リファクタリング**: コードを削除

### 推測的な汎用性

**検出方法**:
- サブクラスが1つしかない抽象クラス
- 使われていないパラメータ/メソッド
- 実現しなかった将来の機能のための「フック」
- 単純な要件に対する過度に複雑な設計

**推奨リファクタリング**: 階層の折りたたみ、クラスのインライン化、パラメータの削除

### 怠惰なクラス

**検出方法**:
- クラスがほとんど何もしない
- クラスがデータを通過させるためだけに存在
- 機能が呼び出し側クラスに簡単に収まる

**推奨リファクタリング**: クラスのインライン化、階層の折りたたみ

---

## 結合子

クラス間の過度な結合。

### 不適切な密結合

**検出方法**:
- クラスが互いの private/内部部分にアクセス
- 一方向にできる双方向の関係
- クラスが互いの実装を知りすぎている

**推奨リファクタリング**: メソッドの移動、フィールドの移動、双方向関連の一方向への変更

### メッセージチェーン

**検出方法**:
- 長いメソッド呼び出しチェーン: `a.getB().getC().getD().doSomething()`
- クライアントがナビゲーション構造に依存
- 中間クラスの変更が遠くのコードを壊す

**推奨リファクタリング**: 委譲の隠蔽

### 仲介者

**検出方法**:
- クラスが主に別のクラスに委譲するだけ
- ほとんどのメソッドが単に呼び出しを転送
- 仲介者からの付加価値がほとんどない

**推奨リファクタリング**: 仲介者の除去、クラスのインライン化

---

## クイック検出チェックリスト

コードレビュー時にこのチェックリストを使用:

- [ ] 20 行を超えるメソッドはあるか？
- [ ] 200 行を超えるクラスはあるか？
- [ ] 4 個を超えるパラメータを持つ関数はあるか？
- [ ] 重複コードブロックはあるか？
- [ ] 深いネスト（3段超）はあるか？
- [ ] マジックナンバーや文字列はあるか？
- [ ] 不明瞭な変数名/メソッド名はあるか？
- [ ] 長いメソッド呼び出しチェーンはあるか？
- [ ] 同じ switch 文が複数箇所にあるか？
- [ ] 未使用のコードやインポートはあるか？
- [ ] 「なぜ」ではなく「何を」説明するコメントはあるか？
- [ ] すべてを行う God クラスはあるか？
