---
name: shortcuts
description: "Claude Code のキーボードショートカット一覧を表示する。ユーザーが /shortcuts と入力した時に発動。"
---

# Claude Code キーボードショートカット

このスキルが呼び出されたら、以下のショートカット一覧をそのまま表示してください。

---

## 主要なショートカット

| ショートカット | 説明 |
|:---|:---|
| `Ctrl+C` | 現在の操作をキャンセル |
| `Ctrl+D` | セッション終了 |
| `Ctrl+G` | 外部エディタで編集 |
| `Ctrl+L` | 画面クリア |
| `Ctrl+R` | コマンド履歴検索 |
| `Ctrl+T` | タスクリスト表示/非表示 |
| `Ctrl+O` | 詳細出力表示の切り替え |
| `Ctrl+B` | Bash コマンドをバックグラウンド実行 |
| `Ctrl+V` | クリップボードから画像を貼り付け |
| `Esc + Esc` | チェックポイントに戻す |
| `Shift+Tab` | 権限モード切り替え |
| `Alt+P` | モデル切り替え |
| `Alt+T` | 拡張思考モード切り替え |

## テキスト編集

| ショートカット | 説明 |
|:---|:---|
| `Ctrl+K` | 行の末尾まで削除 |
| `Ctrl+U` | 行全体を削除 |
| `Ctrl+Y` | 削除したテキストを貼り付け |
| `Alt+B` | カーソルを 1 単語戻す |
| `Alt+F` | カーソルを 1 単語進める |

## 複数行入力

| 方法 | ショートカット |
|:---|:---|
| クイックエスケープ | `\` + `Enter` |
| コントロール文字 | `Ctrl+J` |
| Shift+Enter | `Shift+Enter`（iTerm2、WezTerm、Ghostty、Kitty） |

## 履歴操作

| ショートカット | 説明 |
|:---|:---|
| `Up` / `Down` | コマンド履歴をナビゲート |
| `Left` / `Right` | ダイアログタブをサイクル |

## よく使うスラッシュコマンド

| コマンド | 用途 |
|:---|:---|
| `/help` | ヘルプ表示 |
| `/config` | 設定を開く |
| `/model` | モデル選択 |
| `/clear` | 会話履歴削除 |
| `/cost` | トークン使用統計 |
| `/resume` | 前の会話を再開 |
| `/rewind` | 会話やコード状態を戻す |
| `/theme` | カラーテーマ変更 |
| `/vim` | Vim モード有効化 |
| `/memory` | CLAUDE.md メモリ編集 |

## カスタマイズ

ショートカットは `~/.claude/keybindings.json` でカスタマイズ可能。

```bash
claude /keybindings
```

詳細は `/keybindings-help` スキルを参照。
