---
name: slide-color-design
description: Use when you only need slide color systems, palette selection, or palette generation workflows and want direct pointers to the color design references.
---

# Slide Color Design Entry

## Overview
Thin entry skill for slide color work. Core principle: route directly to the color-design workflow and outputs without reading authoring or SVG modules.

## When to Use
- Designing a slide palette from scratch
- Picking a prebuilt palette or adapting a brand color
- Documenting color roles and usage

## Quick Reference
| Goal | Read |
| --- | --- |
| End-to-end workflow | references/color-design/workflow.md |
| Strategy selection | references/color-design/strategies.md |
| Output format | references/color-design/output-template.md |
| Palette index | references/color-palettes.md |

## Example
Prompt: "Need a light palette from a brand color." → Read `workflow.md`, then `strategies.md`, then `output-template.md`.

## Assets
- `assets/examples/` - Palette example outputs

## Common Mistakes
- Skimming the slide-creator overview instead of the color workflow
- Jumping into Marp authoring before defining palette roles

## Red Flags
- "I'll just scroll until I see colors"
- "I can pick colors after writing slides"
