# Color Strategy Guide

## Table of Contents

- [Strategy 1: Dark Technical](#strategy-1-dark-technical)
  - [Overview](#overview)
  - [Visual Characteristics](#visual-characteristics)
  - [Best For](#best-for)
  - [Avoid If](#avoid-if)
  - [Color Role Guidelines](#color-role-guidelines)
  - [Example Palette](#example-palette)
  - [Tips](#tips)
- [Strategy 2: Light Professional](#strategy-2-light-professional)
  - [Overview](#overview)
  - [Visual Characteristics](#visual-characteristics)
  - [Best For](#best-for)
  - [Avoid If](#avoid-if)
  - [Color Role Guidelines](#color-role-guidelines)
  - [Example Palette](#example-palette)
  - [Tips](#tips)
- [Strategy 3: Accent-Driven](#strategy-3-accent-driven)
  - [Overview](#overview)
  - [Visual Characteristics](#visual-characteristics)
  - [Best For](#best-for)
  - [Avoid If](#avoid-if)
  - [Color Role Guidelines](#color-role-guidelines)
  - [Example Palette](#example-palette)
  - [Tips](#tips)
- [Decision Matrix](#decision-matrix)
- [Mixing Strategies (Advanced)](#mixing-strategies-advanced)
- [See Also](#see-also)

Three primary color strategies for slide design. Choose ONE based on context.

---

## Strategy 1: Dark Technical

### Overview

Dark backgrounds with muted accents, optimized for code and technical diagrams.

### Visual Characteristics

- **Background**: Dark gray (#1E1E1E - #2D2D2D), not pure black
- **Text**: Light gray (#D4D4D4 - #E0E0E0) for readability
- **Accents**: Muted blues, cyans, ambers for highlights
- **Overall feel**: Professional, developer-friendly, reduces eye strain

### Best For

- Code-heavy presentations (lots of syntax highlighting)
- Terminal output and command-line demos
- System architecture diagrams
- Developer conferences and technical meetups
- Night presentations or dark rooms
- Screen recordings and live coding

### Avoid If

- Printing required (dark backgrounds use excessive ink)
- Bright room with strong ambient light (colors may wash out)
- Non-technical audience (may feel too "hacker-like")
- Charts with many categories (dark backgrounds reduce color options)

### Color Role Guidelines

| Role | Typical Range | Example | Notes |
|------|--------------|---------|-------|
| Background | #1E1E1E - #2D2D2D | #1E1E1E | VS Code dark |
| Surface | #252526 - #3C3C3C | #2D2D2D | Slightly lighter |
| Primary | #569CD6 - #61AFEF | #569CD6 | Blue accent |
| Secondary | #4EC9B0 - #98C379 | #4EC9B0 | Cyan/green |
| Accent | #F4BF75 - #FAC863 | #F4BF75 | Amber highlight |
| Text Primary | #D4D4D4 - #E0E0E0 | #D4D4D4 | Light gray |
| Text Secondary | #858585 - #A0A0A0 | #858585 | Muted gray |

### Example Palette

See [../color-palettes.md](../color-palettes.md) for:
- Palette 1: Code-Focused Blue
- Palette 2: Terminal Dark
- Palette 3: Midnight Professional

### Tips

- Use familiar colors (VS Code blue #569CD6 is instantly recognizable to developers)
- Keep syntax highlighting consistent with popular editors
- Test on projector—some dark colors may appear too similar
- Avoid pure white text (#FFFFFF)—it's too harsh on dark backgrounds

---

## Strategy 2: Light Professional

### Overview

Light backgrounds with restrained colors, optimized for business and formal settings.

### Visual Characteristics

- **Background**: Off-white or light gray (#FAFAFA - #F5F5F5)
- **Text**: Near-black or dark gray (#2C2C2C - #212121)
- **Accents**: Corporate blues, muted oranges
- **Overall feel**: Clean, professional, widely acceptable

### Best For

- Business presentations and quarterly reviews
- Documentation-style slides and training materials
- Formal settings (conferences, board meetings)
- Mixed audience (technical + non-technical)
- Bright rooms with lots of ambient light
- Printed handouts

### Avoid If

- Dark room (light backgrounds can be too bright)
- Code-heavy content (syntax highlighting works better on dark)
- Casual or creative audience (may feel too corporate)
- Long presentations (white backgrounds cause more eye strain over time)

### Color Role Guidelines

| Role | Typical Range | Example | Notes |
|------|--------------|---------|-------|
| Background | #FAFAFA - #FFFFFF | #FAFAFA | Off-white |
| Surface | #FFFFFF - #F5F5F5 | #FFFFFF | Pure white panels |
| Primary | #2E75B6 - #1976D2 | #2E75B6 | Corporate blue |
| Secondary | #5B9BD5 - #757575 | #5B9BD5 | Lighter blue/gray |
| Accent | #F39C12 - #FF6F00 | #F39C12 | Orange highlight |
| Text Primary | #2C2C2C - #212121 | #2C2C2C | Near-black |
| Text Secondary | #666666 - #616161 | #666666 | Medium gray |

### Example Palette

See [../color-palettes.md](../color-palettes.md) for:
- Palette 4: Clean Corporate
- Palette 5: Modern Minimal
- Palette 6: Warm Professional

### Tips

- Use #FAFAFA instead of pure white (#FFFFFF) to reduce glare
- Ensure text contrast is very high (≥ 7:1 for AA)
- Conservative colors are safer for business contexts
- Test printed versions—some blues may appear too dark

---

## Strategy 3: Accent-Driven

### Overview

Neutral base (white/light gray) with one strong highlight color for emphasis.

### Visual Characteristics

- **Background**: Pure white or very light gray
- **Base colors**: Grays and charcoal for text and structure
- **Accent**: ONE vibrant color used sparingly (5-10% of elements)
- **Overall feel**: Minimal, story-driven, high-impact

### Best For

- Storytelling and persuasive presentations
- Keynotes and inspirational talks
- Single-message slides (one key idea per slide)
- Design-focused or creative content
- When you want specific elements to "pop"
- Marketing and product launches

### Avoid If

- Complex data or many categories (limited color palette)
- Many competing elements on one slide
- Technical diagrams needing multiple color codes
- Long presentations (minimalism can become boring)

### Color Role Guidelines

| Role | Typical Range | Example | Notes |
|------|--------------|---------|-------|
| Background | #FFFFFF - #F8F9FA | #FFFFFF | Pure white |
| Surface | #F8F9FA - #F0F0F0 | #F8F9FA | Subtle gray |
| Primary | #343A40 - #2F2F2F | #343A40 | Charcoal |
| Secondary | #6C757D - #5F5F5F | #6C757D | Medium gray |
| Accent | #20C997 - #E53935 | #20C997 | Teal or red |
| Text Primary | #212529 - #1A1A1A | #212529 | Near-black |
| Text Secondary | #6C757D - #757575 | #6C757D | Gray |

### Example Palette

See [../color-palettes.md](../color-palettes.md) for:
- Palette 7: Minimal with Teal Focus
- Palette 8: Gray Scale with Red Accent

### Tips

- **Use accent color sparingly**: Only 5-10% of visual space
- Reserve accent for truly important elements (key numbers, CTAs, critical points)
- Everything else should be grayscale
- This strategy requires discipline—resist adding more colors
- Works best with ample whitespace

---

## Decision Matrix

| Context | Best Strategy | Reasoning |
|---------|--------------|-----------|
| API documentation with code examples | Dark Technical | Code readability |
| Corporate Q2 results presentation | Light Professional | Formal, printable |
| Product launch keynote | Accent-Driven | Single message focus |
| System architecture deep-dive | Dark Technical | Diagrams + code |
| Training materials for new hires | Light Professional | Mixed audience |
| Conference talk (30 min) | Accent-Driven or Dark Technical | Depends on code density |

---

## Mixing Strategies (Advanced)

In rare cases, you may combine strategies:

**Example: Dark Technical + Accent-Driven**
- Use dark background (#1E1E1E)
- Keep most colors muted (blues, cyans)
- Add ONE vibrant accent (e.g., hot pink #FF1493) for critical callouts
- Use case: Developer conference talk with key product announcement

**Guidelines**:
- Only mix if explicitly requested or clearly beneficial
- Document why you're mixing strategies
- Ensure visual consistency is maintained

---

## See Also

- [workflow.md](workflow.md) - Complete color design process
- [../color-palettes.md](../color-palettes.md) - Ready-to-use palettes for each strategy
- [output-template.md](output-template.md) - Example outputs
