---
name: svg-illustration
description: Use when you need SVG diagram rules, layout patterns, or embedding guidance for slide decks and want the minimal SVG-focused reading path.
---

# SVG Illustration Entry

## Overview
Thin entry skill for SVG diagrams. Core principle: go straight to SVG rules and patterns rather than scanning slide authoring or color modules.

## When to Use
- Creating slide-ready SVG diagrams or illustrations
- Choosing SVG sizing, spacing, and embedding rules
- Troubleshooting SVG export/embedding issues

## Quick Reference
| Goal | Read |
| --- | --- |
| Core rules | references/core-rules.md |
| Pattern examples | references/pattern-examples.md |
| Embedding in slides | references/embedding.md |
| Troubleshooting | references/troubleshooting.md |

## Example
Prompt: "Need an architecture diagram with clean sizing." → Read `core-rules.md`, then `pattern-examples.md`.

## Assets
- `assets/examples/` - SVG diagram examples

## Common Mistakes
- Reading Marp authoring before SVG rules when only diagrams are needed
- Skimming slide-creator overview instead of SVG references

## Red Flags
- "Maybe SVG rules are buried in authoring"
- "I'll just skim everything"
