# Using Life OS Skill

## Overview

Entry point skill that introduces available Life OS skills, provides command reference, and guides users through the comprehensive Life OS system.

## Purpose

This skill helps you:
- Discover all available Life OS capabilities
- Learn command syntax and usage patterns
- Navigate the skill ecosystem
- Get started with initial setup
- Understand cross-skill integration

## When to Use

- **First time setup**: Getting oriented with Life OS
- **Exploring features**: Learning what's possible
- **Quick reference**: Looking up command syntax
- **Troubleshooting**: Understanding how skills work together

## Key Features

### Skill Discovery
- Comprehensive list of all available skills
- Clear descriptions of each capability
- Usage examples and best practices

### Command Reference
- Quick syntax guide for all skills
- Example commands for common scenarios
- Integration patterns between skills

### Getting Started Guide
- Step-by-step onboarding flow
- Personality assessment setup
- Daily briefing configuration
- First meal plan creation

### Cross-Skill Coordination
- How skills work together automatically
- Data flow between skills
- Session management and context restoration

## Usage

```
/skill using-life-os
```

This loads the comprehensive guide with:
- Available skills overview
- Command reference
- Getting started workflow
- Example use cases
- Integration details

## Integration with Other Skills

- **Entry point** for new users
- **Reference guide** for experienced users
- **Context provider** for all other skills
- **SessionStart hook** automatically loads this skill

## Best Practices

1. **Bookmark this skill** for quick reference
2. **Review periodically** to discover new features
3. **Share with new users** for onboarding
4. **Use as troubleshooting guide** when stuck

## Dependencies

None - this is the entry point skill

## Output

Comprehensive markdown guide covering:
- Skill catalog
- Command syntax
- Getting started steps
- Example workflows
- Tips and best practices
