---
name: ideation
description: Guides structured ideation through Socratic questioning to explore problems, opportunities, and solutions. Use when brainstorming features, exploring use cases, or thinking through new ideas.
---

# Ideation

A structured questioning approach to help think through new features, use cases, problems, and opportunities.

## How This Works

Instead of jumping to solutions, guide the user through layers of understanding:

1. **Problem/Opportunity Space** - What's the real issue or opportunity?
2. **Context & Constraints** - What's the environment and limitations?
3. **User & Stakeholder Lens** - Who's affected and how?
4. **Solution Exploration** - What are the options?
5. **Validation & Risks** - How do we know it works?

## Questioning Framework

### Layer 1: Surface Understanding
Start here to clarify what they're actually trying to do:
- "What triggered this idea? What happened that made you think of this?"
- "In one sentence, what problem are you trying to solve?"
- "Who would benefit if this existed?"
- "What does success look like?"

### Layer 2: Problem Depth
Dig into the mechanics of the problem:
- "Why does this problem exist? What's the root cause?"
- "How are people solving this today? What's wrong with that approach?"
- "What's the cost of not solving this? (time, money, frustration)"
- "Is this a hair-on-fire problem or a nice-to-have?"

### Layer 3: Context & Constraints
Understand the boundaries:
- "What technical constraints exist? (stack, integrations, performance)"
- "What resources are available? (time, team, budget)"
- "What's non-negotiable vs. flexible?"
- "What have you tried before that didn't work?"

### Layer 4: User Perspective
Get specific about who you're building for:
- "Walk me through the user's current workflow without this solution."
- "What's the most painful step? Where do they give up?"
- "What would they say if you asked them about this problem?"
- "Are there different user segments with different needs?"

### Layer 5: Solution Exploration
Now explore options:
- "What's the simplest version that would still be useful?"
- "What would the ideal solution look like with no constraints?"
- "What existing solutions come close? What's missing?"
- "What are 3 completely different approaches to this?"

### Layer 6: Validation & Risk
Stress-test the idea:
- "How would we know if this is working?"
- "What could go wrong? What are the biggest risks?"
- "What assumptions are we making that might be wrong?"
- "What's the smallest experiment we could run to learn more?"

## Process

1. **Listen first** - Let them explain the idea before questioning
2. **One question at a time** - Don't overwhelm with multiple questions
3. **Summarize understanding** - Reflect back what you heard before moving deeper
4. **Adapt the layer** - Skip layers that aren't relevant; go deeper where needed
5. **Capture insights** - Periodically summarize key discoveries
6. **End with clarity** - Conclude with a clear problem statement + potential next steps

## Output Artifacts

After the ideation session, offer to create:
- **Problem Statement**: One-paragraph summary of the problem/opportunity
- **Key Insights**: Bullet list of discoveries from the conversation
- **Solution Options**: 2-3 approaches with tradeoffs
- **Next Steps**: Concrete actions to move forward
- **Open Questions**: Things that still need answers

## Example Opening

When the skill is triggered, start with:

> "Before we dive into solutions, let me understand the problem space first. What triggered this idea? What's the situation or pain point you're seeing?"

Then adapt based on their response - go deeper on problem understanding before exploring solutions.
