# [Project Name]: Implementation Guide

This guide walks you through building [brief description] from scratch. Each milestone includes verifiable checkpoints so you can confirm your progress before moving on.

More importantly, this guide explains _why_ you're making each decision. Understanding the reasoning behind architectural choices will help you adapt these patterns to your own projects and make better decisions when you inevitably encounter situations this guide doesn't cover.

## What You're Building

**[Project Name]** is [one-sentence description]. [Optional: analogy or comparison]. Key features:

-  [Feature 1 - brief description]
-  [Feature 2 - brief description]
-  [Feature 3 - brief description]
-  [Feature 4 - brief description]

### Why These Features Matter

**[Feature 1]** [explain why this feature is essential, not just nice-to-have. Include real-world scenarios or pain points it solves.]

**[Feature 2]** [explain the importance and what problems it prevents or enables.]

**[Additional features...]**

## Tech Stack

Here's what we're using and _why_ each piece was chosen:

### [Technology 1]: [Name]

**What it is:** [Brief explanation of what this technology is]

**Why we're using it:** [Specific benefits for this project - be concrete about advantages]

**The tradeoff:** [Honest discussion of downsides, limitations, or alternatives you're not using]

### [Technology 2]: [Name]

**What it is:** [Brief explanation]

**Why we're using it:** [Specific benefits]

**The tradeoff:** [Honest discussion]

[Continue for each major technology choice...]

## Time Estimate

-  **Phase 1:** [X-Y hours] ([brief description])
-  **Phase 2:** [X-Y hours] ([brief description])
-  **Total:** [X-Y hours]

[Include note about how time might vary based on experience or deep learning goals]

## Cost

-  **[Service 1]:** $X ([details of free tier or pricing])
-  **[Service 2]:** $X ([details])
-  **Total:** $X/month

---

## Prerequisites

Before starting, ensure you have these installed:

### 1. [Tool/Requirement Name]

[Installation instructions with actual commands]

```bash
# Installation command
```

**Why [Tool] over [Alternative]?** [Brief explanation of the choice]

### 2. Verify Your Setup

```bash
[command] --version  # Should show X.x or higher
[command] --version  # Any recent version
```

### 3. Accounts You'll Need

-  **[Service 1]** — [What it's used for and where to get it]
-  **[Service 2]** — [What it's used for]

---

## Milestone 1: [Milestone Name]

**Goal:** [One clear sentence describing what this milestone achieves]

**Why start here?** [Explain why this milestone comes first - what foundation does it establish?]

### Step 1.1: [Step Name]

```bash
[command or code]
```

**What just happened?**

-  [Explain what the command did]
-  [Explain what was created or configured]
-  [Point out notable details or effects]

[Additional context if needed - explain concepts used, why certain flags or options matter]

### Step 1.2: [Next Step Name]

[Code block with extensive inline comments explaining the "why"]

```typescript
// Example with inline comments
function example() {
   // This does X because Y
   const value = someFunction();

   // We use this approach instead of Z because...
   return processValue(value);
}
```

**Understanding the implementation:**

-  [Explain key concept 1]
-  [Explain important detail 2]
-  [Discuss edge case 3]

**Why this approach?** [If there's an important decision here, explain the reasoning inline]

**The tradeoff:** [If applicable, discuss what you're giving up or complexity being added]

### Step 1.3: [Verification Step]

```bash
[command to run]
```

**Checkpoint:** [Describe what to verify - be specific about expected results]

1. [Specific thing to check 1]
   -  ✓ [Expected result]
2. [Specific thing to check 2]
   -  ✓ [Expected result]
3. [What success looks like overall]
   -  ✓ [Expected outcome]

**If something went wrong:**

-  **Error X**: [How to fix it]
-  **Error Y**: [How to fix it]

Note: [Any important observation about what was just accomplished]

**Milestone 1 Complete!** [Summarize what was achieved]

-  [Key accomplishment 1]
-  [Key accomplishment 2]
-  [Key accomplishment 3]

---

## Milestone 2: [Next Milestone Name]

**Goal:** [Clear statement of what this achieves]

**Why now?** [Explain why this milestone follows the previous one]

[Continue with numbered steps 2.1, 2.2, etc. following the same pattern...]

---

[Continue with additional milestones...]

---

## Summary

Congratulations! You've built [project description]. Here's what you've accomplished:

### What You Built

| Feature     | Milestone | Why It Matters  |
| ----------- | --------- | --------------- |
| [Feature 1] | 1         | [Brief benefit] |
| [Feature 2] | 2         | [Brief benefit] |
| [Feature 3] | 3         | [Brief benefit] |

[Continue for all major features...]

### Architecture Overview

```
[ASCII diagram showing how components interact - optional but helpful]
```

[Or prose explanation of the high-level architecture]

### Key Learnings

1. **[Learning 1]** — [Brief explanation of important concept or pattern]
2. **[Learning 2]** — [Brief explanation]
3. **[Learning 3]** — [Brief explanation]
   [3-5 key takeaways from the implementation]

### What's Next?

Optional enhancements you could add:

1. **[Enhancement 1]** — [Brief description] ([time estimate])
2. **[Enhancement 2]** — [Brief description] ([time estimate])
3. **[Enhancement 3]** — [Brief description] ([time estimate])

### Monthly Costs

-  **[Service 1]:** $X ([details])
-  **[Service 2]:** $X ([details])
-  **Total:** $X/month

### Useful Commands Reference

```bash
# [Category 1]
[command]  # [What it does]
[command]  # [What it does]

# [Category 2]
[command]  # [What it does]
[command]  # [What it does]
```

---

[Closing thought or encouragement about what they've learned and can now build]
