# What is Neon

Neon is a serverless Postgres platform that separates compute and storage to offer autoscaling, branching, instant restore, and scale-to-zero.

See the [official introduction](https://neon.com/docs/introduction.md) for complete details.

## Core Concepts

| Concept          | Description                                                           | Key Relationship          |
| ---------------- | --------------------------------------------------------------------- | ------------------------- |
| Organization     | Highest-level container for billing, users, and projects              | Contains Projects         |
| Project          | Primary container for all database resources for an application       | Contains Branches         |
| Branch           | Lightweight, copy-on-write clone of database state                    | Contains Databases, Roles |
| Compute Endpoint | Running PostgreSQL instance (CPU/RAM for queries)                     | Attached to a Branch      |
| Database         | Logical container for data (tables, schemas, views)                   | Exists within a Branch    |
| Role             | PostgreSQL role for authentication and authorization                  | Belongs to a Branch       |
| Operation        | Async action by the control plane (creating branch, starting compute) | Associated with Project   |

## Key Differentiators

1. **Serverless Architecture**: Compute scales automatically and can suspend when idle
2. **Branching**: Create instant database copies without duplicating storage
3. **Separation of Compute and Storage**: Pay for compute only when active
4. **Postgres Compatible**: Works with any Postgres driver, ORM, or tool

## When to Use Neon

- **Serverless applications**: Functions that need database access without managing connections
- **Development workflows**: Branch databases like code for isolated testing
- **Variable workloads**: Auto-scale during traffic spikes, scale to zero when idle
- **Cost optimization**: Pay only for active compute time and storage used

## Further Reading

| Topic                  | URL                                                         |
| ---------------------- | ----------------------------------------------------------- |
| Architecture           | https://neon.com/docs/introduction/architecture-overview.md |
| Plans & Billing        | https://neon.com/docs/introduction/about-billing.md         |
| Regions                | https://neon.com/docs/introduction/regions.md               |
| Postgres Compatibility | https://neon.com/docs/reference/compatibility.md            |
