---
name: design-expert
description: "UI/UX design expertise - component design, design systems, responsive design, Figma analysis"
autoInvoke: false
priority: medium
triggers:
  - "design component"
  - "UI breakdown"
  - "design system"
  - "responsive layout"
---

# Skill: Design Expert

**Category:** Reference Skill
**Used By:** ui-expert agent

---

## Sub-Skills

| File | Purpose |
|------|---------|
| `component-design.md` | Atomic design, component anatomy, specs |
| `design-system.md` | Design tokens, theming, consistency |
| `responsive-design.md` | Mobile-first, breakpoints, layouts |
| `figma-analysis.md` | Figma file analysis techniques |

---

## When to Use

- Phase 3 (UI Breakdown) - Component design decisions
- UI/UX design tasks
- Design system setup
- Responsive layout planning

---

## Quick Reference

**Atomic Design:**
```
Atoms → Molecules → Organisms → Templates → Pages
```

**Design Tokens:**
- Colors, spacing, typography, shadows, borders

**Responsive Breakpoints:**
- Mobile: < 768px
- Tablet: 768px - 1024px
- Desktop: > 1024px

---

## Related Skills

For implementation with specific design system libraries, use:

**Design System Library:** `skills/design-system-library/`

| System | File |
|--------|------|
| Material UI | `material-ui.md` |
| Ant Design | `ant-design.md` |
| Tailwind CSS | `tailwind-css.md` |
| shadcn/ui | `shadcn-ui.md` |
| Chakra UI | `chakra-ui.md` |
| NativeWind | `nativewind.md` |
| Bootstrap | `bootstrap.md` |
| Mantine | `mantine.md` |
| Radix UI | `radix-ui.md` |
| Headless UI | `headless-ui.md` |

---

**Load sub-skills as needed for detailed guidance.**
