# Stitch Design Review Checklist

Use this checklist when reviewing designs generated by Google Stitch.

---

## Visual Design

### Colors
- [ ] Color palette is cohesive (3-5 colors max)
- [ ] Sufficient contrast for readability (WCAG AA: 4.5:1)
- [ ] Accent colors used consistently for CTAs
- [ ] Dark/light mode considerations (if applicable)
- [ ] Colors match brand guidelines

### Typography
- [ ] Font hierarchy is clear (H1 > H2 > H3 > body)
- [ ] Body text is readable (16px minimum on web)
- [ ] Line height is comfortable (1.5-1.7 for body)
- [ ] Font pairing works (max 2 font families)
- [ ] Text has proper contrast against background

### Spacing & Layout
- [ ] Consistent spacing system (8px grid)
- [ ] Adequate white space
- [ ] Elements are aligned properly
- [ ] Visual balance across the page
- [ ] Clear content grouping

### Visual Elements
- [ ] Icons are consistent in style
- [ ] Images are appropriate and high-quality
- [ ] Illustrations match brand tone
- [ ] Border radius is consistent
- [ ] Shadows are subtle and purposeful

---

## UX/Usability

### Navigation
- [ ] Navigation is immediately understandable
- [ ] Current location is clear
- [ ] Important actions are accessible
- [ ] Back/forward navigation is obvious
- [ ] Mobile menu works well (if applicable)

### Actions & CTAs
- [ ] Primary CTA is prominent
- [ ] Button hierarchy is clear (primary/secondary/tertiary)
- [ ] Clickable elements look clickable
- [ ] Disabled states are distinguishable
- [ ] Loading states considered

### Content
- [ ] Information hierarchy is logical
- [ ] Most important content is above the fold
- [ ] Scannable with headings and lists
- [ ] Empty states are designed
- [ ] Error messages are helpful

### Forms
- [ ] Labels are clear and positioned correctly
- [ ] Required fields are marked
- [ ] Input fields are appropriately sized
- [ ] Validation feedback is inline
- [ ] Submit button is obvious

---

## Accessibility

### Basic A11y
- [ ] Touch targets are 44x44pt minimum (mobile)
- [ ] Focus states are visible
- [ ] Color is not the only indicator
- [ ] Text can be resized without breaking layout
- [ ] Images have alt text consideration

### Screen Reader
- [ ] Heading hierarchy is correct (H1 → H2 → H3)
- [ ] Form inputs have labels
- [ ] Links have descriptive text
- [ ] ARIA landmarks considered
- [ ] Skip to content link (web)

---

## Responsive Design

### Breakpoints
- [ ] Mobile design works (< 768px)
- [ ] Tablet design works (768-1024px)
- [ ] Desktop design works (> 1024px)
- [ ] No horizontal scroll
- [ ] Touch-friendly on mobile

### Adaptation
- [ ] Navigation adapts appropriately
- [ ] Images scale correctly
- [ ] Typography scales (fluid or stepped)
- [ ] Grid adjusts column count
- [ ] Modals work on all sizes

---

## Technical Feasibility

### Implementation
- [ ] Design can be built with target framework
- [ ] Components are reusable
- [ ] States are defined (hover, active, disabled)
- [ ] Animations are reasonable to implement
- [ ] No impossible layouts

### Performance
- [ ] Images are reasonable file sizes
- [ ] Animations won't cause jank
- [ ] Layout won't cause excessive repaints
- [ ] Fonts are web-optimized
- [ ] Minimal third-party dependencies

---

## Brand Alignment

### Consistency
- [ ] Matches existing brand guidelines
- [ ] Consistent with other products
- [ ] Tone matches brand voice
- [ ] Visual style is appropriate for audience
- [ ] No conflicting design patterns

### Business Goals
- [ ] Supports primary user task
- [ ] Conversion path is clear
- [ ] Key metrics can be measured
- [ ] A/B test variations possible
- [ ] Scalable for future features

---

## Quick Score

Rate each category (1-5):

| Category | Score | Notes |
|----------|-------|-------|
| Visual Design | /5 | |
| UX/Usability | /5 | |
| Accessibility | /5 | |
| Responsive | /5 | |
| Technical | /5 | |
| Brand | /5 | |
| **Total** | **/30** | |

**Scoring Guide:**
- 25-30: Ready for implementation
- 20-24: Minor revisions needed
- 15-19: Significant revisions needed
- < 15: Major redesign required

---

**Version:** 1.0.0
