---
name: code-explanation
description: Use when explaining code, concepts, or system behavior to a specific audience level - provides a structured explanation workflow with depth control and validation steps.
---

# Code Explanation

## Overview
Provide clear explanations of code and concepts with appropriate depth, structure, and examples. Adapt the output to the audience level.

## When to Use
- Explaining code, architecture, or system behavior
- Producing educational explanations for knowledge transfer
- Clarifying framework or domain concepts

Avoid when:
- The request is strictly documentation generation (use documentation-production)

## Quick Reference

| Task | Load reference |
| --- | --- |
| Explanation workflow | `skills/code-explanation/references/explain.md` |
| **Pedagogical Methodology** | `skills/code-explanation/references/pedagogical-methodology.md` |

## Workflow
1. Identify target, audience level, and format.
2. Load the explanation reference.
3. Analyze the code or concept.
4. Structure the explanation with progressive depth.
5. Validate accuracy and clarity.

## Output
- Structured explanation with examples
- Notes on assumptions and follow-ups

## Common Mistakes
- Skipping audience level calibration
- Explaining without verifying source behavior
