# [Project Name] - Core Idea

**Variables**: Variables in CAPS are injected by hooks (see HTML comments above), `{vars}` are runtime values (find/calculate them), `[vars]` are template placeholders (substitute them).

## The Problem

**What specific problem does this solve?**

[Describe the real problem you're addressing. Focus on pain points people actually experience, not theoretical issues.]

**Who has this problem?**

[Define the target user - be specific about their context, workflow, and constraints.]

**How do they solve it today?**

[Document current solutions and their limitations. This helps validate the problem is real and worth solving.]

## The Solution

**Core Value Proposition**

[In 1-2 sentences, what value does this project deliver? What's the key insight or approach that makes this better?]

**Key Differentiators**

- [What makes this solution unique or better than alternatives?]
- [What's the core insight that others are missing?]
- [What constraints or trade-offs are you optimizing for?]

## System Flow (Initial Sketch)

> **Note**: This is a preliminary sketch of system operation. The actual workflow will evolve significantly during development.

1. [Step 1 - Initial system input or trigger]
2. [Step 2 - System processing or data transformation]
3. [Step 3 - Core system logic or analysis]
4. [Step 4 - Output generation or result processing]
5. [Step 5 - Final system state or storage]

## User Experience Vision

**Primary User Journey**

1. [Step 1 - How users discover/start using this]
2. [Step 2 - Core interaction or workflow]
3. [Step 3 - Value realization or outcome]

**Core User Workflows**

- [Workflow 1 - Most common user task]
- [Workflow 2 - Secondary important workflow]
- [Workflow 3 - Administrative or setup workflow]

**Success Criteria**

- [How will you know this is working? Concrete, measurable outcomes]
- [What user behavior or feedback indicates success?]
- [What metrics matter for this project?]

## MVP Definition

**What is the absolute minimum viable version?**

[Describe the simplest version that still solves the core problem and delivers value to users]

**MVP Scope**

- [Core feature 1 - absolutely essential]
- [Core feature 2 - must have for basic value]
- [Core feature 3 - minimum viable functionality]

**MVP Constraints**

- [What can be hardcoded, simplified, or deferred in MVP?]
- [What integrations can be manual or simplified initially?]
- [What edge cases can be ignored for MVP?]

**Post-MVP Evolution**

- [What gets added in iteration 2?]
- [What gets automated or improved after MVP?]

## Features Status

**Status Legend:**

- 📋 **Planned** - Feature defined and ready for iteration planning
- 🔄 **In Progress** - Feature currently being developed (iteration-N)
- ✅ **Built** - Feature completed and shipped

**Current Features:**

- 📋 [Feature 1 - what the solution does]
- 📋 [Feature 2 - another capability]
- 📋 [Feature 3 - additional functionality]
- 📋 [Feature 4 - more capabilities as envisioned]

## Technical Approach

**Architecture Decision**

- [ ] **Single Tool/Application** - Integrated solution, focused functionality
- [ ] **Composed Tool Ecosystem** - Multiple tools with clean interfaces

**Why this approach?**

[Justify the architectural choice based on user needs, team constraints, and solution requirements]

**Dependencies & Prerequisites**

- [External APIs or services required]
- [Accounts or access needed]
- [Data sources that must be available]
- [Infrastructure or deployment requirements]

**Integration Requirements**

- [What external systems does this need to work with?]
- [What data needs to be imported or exported?]
- [What authentication or authorization is required?]

**Data Requirements**

- [What data needs to be stored?]
- [What data transformations are required?]
- [What data needs to be retrieved or searched?]

**Key Technical Constraints**

- [Performance requirements, if any]
- [Security or compliance requirements]
- [Platform or deployment constraints]

## Technical Architecture (Tentative)

> **Note**: This section captures current technical thinking and design exploration. All architectural decisions and implementation details are subject to change based on validation, iteration learnings, and practical constraints discovered during development.

**Data Design (Draft)**

[Data structures, file organization, API contracts - current thinking but expect evolution]

**Component Architecture (Working Model)**

[System components, their responsibilities, and interfaces - architectural exploration in progress]

**Integration Points (Planned)**

[How this integrates with existing tools/systems - integration strategy under development]

**Tool/Technology Stack (Current Thinking)**

[Specific tools, frameworks, libraries being considered - selections may change based on requirements evolution]

## Implementation Strategy (Subject to Change)

> **Note**: This section explores potential implementation approaches and operational considerations. These represent current thinking and will evolve significantly based on prototyping results, user feedback, and practical constraints discovered during development.

**Iteration Priorities (Draft)**

- [What should be built first and why?]
- [What can be deferred to later iterations?]
- [What are the key validation points between iterations?]

**Deployment/Operations (Initial Thoughts)**

[How this gets deployed, monitored, maintained - operational strategy in early stages]

**Data Flow (Conceptual)**

[How data moves through the system - current mental model, likely to evolve]

**Decision Logic (Draft)**

[Business rules, algorithms, decision criteria - logic under active development]

**Automation/Orchestration (Exploration)**

[How different components coordinate and trigger - orchestration approach being explored]

## Learning and Evolution

**Key Learnings**

- [What have you learned from building/using this so far?]
- [What assumptions have been validated or invalidated?]
- [What user feedback has shaped the direction?]

**Evolution Notes**

- [How has the idea changed from the original concept?]
- [What features have been added, removed, or reprioritized?]
- [What technical approaches have been tried or abandoned?]

## Open Questions

**User/Market Questions**

- [Questions about user needs, workflows, or problem validation]
- [Market size, competition, or positioning questions]

**Technical Questions**

- [Architecture decisions that need more investigation]
- [Performance, scalability, or integration unknowns]
- [Implementation approach uncertainties]

**Operational Questions**

- [Deployment, monitoring, maintenance considerations]
- [Resource requirements, cost implications]
- [Security, compliance, legal considerations]

## Success Metrics

**Primary Metrics**

- [How will you measure if this project is successful?]
- [What user behavior indicates the problem is being solved?]

**Learning Metrics**

- [How will you measure if you're learning about user needs?]
- [What feedback mechanisms will guide iteration planning?]

## Risks and Assumptions

**Key Assumptions**

- [Assumption about user behavior or needs]
- [Technical assumption about feasibility or approach]
- [Market or competitive assumption]

**Primary Risks**

- [What could make this project fail?]
- [What external dependencies could cause problems?]
- [What technical risks need mitigation?]

**Mitigation Strategies**

- [How will you validate key assumptions quickly?]
- [What's the backup plan if primary approach doesn't work?]

---

## Template Usage Notes

**This Document Should:**

- Capture both high-level vision AND technical exploration with appropriate caveats
- Include system flow and MVP definition to guide iteration planning
- Stay current with learnings and feedback while preserving evolution history
- Guide feature and technical decisions while acknowledging uncertainty
- Communicate project context at both strategic and tactical levels
- Track feature development status through iterations
- Support complex technical projects that require architectural thinking

**This Document Should NOT:**

- Lock in technical architecture or implementation decisions prematurely
- Replace prototyping, user research, or technical validation
- Become a static planning document that doesn't evolve
- Present tentative technical thinking as final decisions
- Overwhelm simple projects with unnecessary technical detail

**Template Flexibility:**

- **Simple projects**: Use core sections only, skip technical architecture sections if not relevant
- **Complex projects**: Use all sections to capture both vision and technical exploration
- **MVP focus**: Clearly define minimum viable version to guide first iteration
- **System vs User flows**: Separate technical process from user experience
- **Iteration guidance**: Include priorities and dependencies to support planning
- **Evolution tracking**: Keep evolution notes to track how thinking has changed over time