# GSAP Skill

Professional-grade JavaScript animation library for the modern web.

## Installation

```bash
npx skills add noklip-io/agent-skills --skill gsap
```

## What's Covered

This modular skill includes 14 comprehensive reference files:

| Reference | Topics |
|-----------|--------|
| `00-cheatsheet.md` | Quick reference for common operations |
| `01-core.md` | gsap.to, from, fromTo, quickTo, ticker, registerEffect, keyframes |
| `02-easing.md` | All easing functions, custom eases, bounce, wiggle |
| `03-timeline.md` | Sequencing, positioning, labels, nesting, control |
| `04-stagger.md` | Staggered animations, grid distributions |
| `05-utilities.md` | toArray, selector, clamp, mapRange, interpolate, pipe |
| `06-scrolltrigger.md` | Scroll-based animations, pin, scrub, snap |
| `07-scrollsmoother.md` | Smooth scrolling, parallax, lag effects |
| `08-splittext.md` | Text splitting and animation |
| `09-svg-plugins.md` | DrawSVG, MorphSVG, MotionPath |
| `10-flip.md` | Layout animations (FLIP technique) |
| `11-react.md` | useGSAP hook, cleanup, React patterns |
| `12-observer-draggable.md` | Gesture detection, draggable elements |
| `13-text-plugins.md` | TextPlugin, ScrambleTextPlugin |

## Triggers

This skill activates when you mention:

- GSAP, GreenSock, gsap.to, gsap.from, gsap.timeline
- ScrollTrigger, scroll animation, scroll-linked animation
- ScrollSmoother, smooth scroll, parallax
- SplitText, text animation, character animation
- DrawSVG, MorphSVG, MotionPath, SVG animation
- Flip plugin, layout animation, FLIP technique
- useGSAP, @gsap/react
- Draggable, Observer, drag and drop
- TextPlugin, ScrambleTextPlugin, typewriter effect

## Resources

- [GSAP Documentation](https://gsap.com/docs/v3/)
- [GSAP Ease Visualizer](https://gsap.com/docs/v3/Eases/)
- [GitHub Repository](https://github.com/greensock/GSAP)
- [GreenSock Forums](https://gsap.com/community/)
