# nuqs Skill

Best practices for nuqs - type-safe URL query state management for React.

## Installation

```bash
npx skills add noklip-io/agent-skills --skill nuqs
```

## What's Covered

- Setup with adapters (Next.js, React, Remix, React Router)
- Core hooks: `useQueryState`, `useQueryStates`
- All built-in parsers with examples
- Server Components with `createSearchParamsCache`
- Testing with `withNuqsTestingAdapter`
- Common patterns and reusable definitions
- Critical mistakes and how to avoid them

## Triggers

This skill activates when you mention:

- nuqs, useQueryState, useQueryStates
- URL query state, search params state
- "sync state with URL", "store state in URL"
- Filterable lists, sortable tables with URL state
- Pagination with query params

## Resources

- [nuqs Documentation](https://nuqs.dev/)
- [GitHub Repository](https://github.com/47ng/nuqs)
