# Theatre.js Skill

Motion design editor and animation library for the web.

## Installation

```bash
npx skills add noklip-io/agent-skills --skill theatre-js
```

## What's Covered

This modular skill includes 6 comprehensive reference files:

| Reference | Topics |
|-----------|--------|
| `01-core.md` | Project, Sheet, Object, Sequence, playback control, pointers |
| `02-prop-types.md` | All prop types, custom types, compound props, constraints |
| `03-studio.md` | Studio UI, keyboard shortcuts, extensions, panels, export |
| `04-react-integration.md` | useVal, usePrism, Atom, Theatric, @theatre/react |
| `05-r3f-integration.md` | React Three Fiber, editable, SheetProvider, cameras |
| `06-production.md` | Export state, assets, deployment, tree-shaking |

## Triggers

This skill activates when you mention:

- Theatre.js, @theatre/core, @theatre/studio
- Motion design, timeline animation, keyframe animation
- Visual animation editor, animation tooling
- @theatre/r3f, theatric, editable components
- Animating Three.js or React Three Fiber scenes

## Resources

- [Theatre.js Documentation](https://www.theatrejs.com/docs/latest)
- [GitHub Repository](https://github.com/theatre-js/theatre)
- [Discord Community](https://discord.gg/bm9f8F9Y9N)
