# Three.js Skill

Comprehensive Three.js reference for 3D web graphics.

## Installation

```bash
npx skills add noklip-io/agent-skills --skill three-js
```

## What's Included

18 reference files covering all aspects of Three.js:

| Category | References |
|----------|------------|
| **Core** | fundamentals, geometry, cameras, math |
| **Visuals** | materials, textures, lighting, shaders |
| **Motion** | animation, interaction, controls |
| **Assets** | loaders (GLTF, FBX, SVG, fonts, HDR) |
| **Effects** | post-processing (bloom, DOF, SSAO) |
| **Advanced** | performance, WebGPU, TSL, physics, VR/XR, patterns |

## Triggers

This skill activates when you mention:

- Three.js, threejs, WebGL, WebGPU
- "create a 3D scene", "add a mesh", "load a GLTF model"
- "implement OrbitControls", "add bloom", "write a shader"
- GLTF, raycaster, PBR material, post-processing

## Note

This skill covers **vanilla Three.js** (imperative JavaScript). For React Three Fiber (@react-three/fiber, R3F, drei), use the `r3f-best-practices` skill.
