---
name: programming-swift
description: The complete Swift Programming Language book by Apple, covering syntax, features, concurrency, and the formal language reference.
---

# The Swift Programming Language (6.2.3)

}

## Documentation Structure

### Welcome to Swift

- **About Swift** ([GuidedTour/AboutSwift.md](GuidedTour/AboutSwift.md)): Understand the high-level goals of the language.
- **Version Compatibility** ([GuidedTour/Compatibility.md](GuidedTour/Compatibility.md)): Learn what functionality is available in older language modes.
- **A Swift Tour** ([GuidedTour/GuidedTour.md](GuidedTour/GuidedTour.md)): Explore the features and syntax of Swift.

### Language Guide

- **The Basics** ([LanguageGuide/TheBasics.md](LanguageGuide/TheBasics.md)): Work with common kinds of data and write basic syntax.
- **Basic Operators** ([LanguageGuide/BasicOperators.md](LanguageGuide/BasicOperators.md)): Perform operations like assignment, arithmetic, and comparison.
- **Strings and Characters** ([LanguageGuide/StringsAndCharacters.md](LanguageGuide/StringsAndCharacters.md)): Store and manipulate text.
- **Collection Types** ([LanguageGuide/CollectionTypes.md](LanguageGuide/CollectionTypes.md)): Organize data using arrays, sets, and dictionaries.
- **Control Flow** ([LanguageGuide/ControlFlow.md](LanguageGuide/ControlFlow.md)): Structure code with branches, loops, and early exits.
- **Functions** ([LanguageGuide/Functions.md](LanguageGuide/Functions.md)): Define and call functions, label their arguments, and use their return values.
- **Closures** ([LanguageGuide/Closures.md](LanguageGuide/Closures.md)): Group code that executes together, without creating a named function.
- **Enumerations** ([LanguageGuide/Enumerations.md](LanguageGuide/Enumerations.md)): Model custom types that define a list of possible values.
- **Structures and Classes** ([LanguageGuide/ClassesAndStructures.md](LanguageGuide/ClassesAndStructures.md)): Model custom types that encapsulate data.
- **Properties** ([LanguageGuide/Properties.md](LanguageGuide/Properties.md)): Access stored and computed values that are part of an instance or type.
- **Methods** ([LanguageGuide/Methods.md](LanguageGuide/Methods.md)): Define and call functions that are part of an instance or type.
- **Subscripts** ([LanguageGuide/Subscripts.md](LanguageGuide/Subscripts.md)): Access the elements of a collection.
- **Inheritance** ([LanguageGuide/Inheritance.md](LanguageGuide/Inheritance.md)): Subclass to add or override functionality.
- **Initialization** ([LanguageGuide/Initialization.md](LanguageGuide/Initialization.md)): Set the initial values for a type's stored properties and perform one-time setup.
- **Deinitialization** ([LanguageGuide/Deinitialization.md](LanguageGuide/Deinitialization.md)): Release resources that require custom cleanup.
- **Optional Chaining** ([LanguageGuide/OptionalChaining.md](LanguageGuide/OptionalChaining.md)): Access members of an optional value without unwrapping.
- **Error Handling** ([LanguageGuide/ErrorHandling.md](LanguageGuide/ErrorHandling.md)): Respond to and recover from errors.
- **Concurrency** ([LanguageGuide/Concurrency.md](LanguageGuide/Concurrency.md)): Perform asynchronous operations.
- **Macros** ([LanguageGuide/Macros.md](LanguageGuide/Macros.md)): Use macros to generate code at compile time.
- **Type Casting** ([LanguageGuide/TypeCasting.md](LanguageGuide/TypeCasting.md)): Determine a value's runtime type and give it more specific type information.
- **Nested Types** ([LanguageGuide/NestedTypes.md](LanguageGuide/NestedTypes.md)): Define types inside the scope of another type.
- **Extensions** ([LanguageGuide/Extensions.md](LanguageGuide/Extensions.md)): Add functionality to an existing type.
- **Protocols** ([LanguageGuide/Protocols.md](LanguageGuide/Protocols.md)): Define requirements that conforming types must implement.
- **Generics** ([LanguageGuide/Generics.md](LanguageGuide/Generics.md)): Write code that works for multiple types and specify requirements for those types.
- **Opaque and Boxed Protocol Types** ([LanguageGuide/OpaqueTypes.md](LanguageGuide/OpaqueTypes.md)): Hide implementation details about a value's type.
- **Automatic Reference Counting** ([LanguageGuide/AutomaticReferenceCounting.md](LanguageGuide/AutomaticReferenceCounting.md)): Model the lifetime of objects and their relationships.
- **Memory Safety** ([LanguageGuide/MemorySafety.md](LanguageGuide/MemorySafety.md)): Structure your code to avoid conflicts when accessing memory.
- **Access Control** ([LanguageGuide/AccessControl.md](LanguageGuide/AccessControl.md)): Manage the visibility of code by declaration, file, and module.
- **Advanced Operators** ([LanguageGuide/AdvancedOperators.md](LanguageGuide/AdvancedOperators.md)): Define custom operators, perform bitwise operations, and use builder syntax.

### Language Reference

- **About the Language Reference** ([ReferenceManual/AboutTheLanguageReference.md](ReferenceManual/AboutTheLanguageReference.md)): Read the notation that the formal grammar uses.
- **Lexical Structure** ([ReferenceManual/LexicalStructure.md](ReferenceManual/LexicalStructure.md)): Use the lowest-level components of the syntax.
- **Types** ([ReferenceManual/Types.md](ReferenceManual/Types.md)): Use built-in named and compound types.
- **Expressions** ([ReferenceManual/Expressions.md](ReferenceManual/Expressions.md)): Access, modify, and assign values.
- **Statements** ([ReferenceManual/Statements.md](ReferenceManual/Statements.md)): Group expressions and control the flow of execution.
- **Declarations** ([ReferenceManual/Declarations.md](ReferenceManual/Declarations.md)): Introduce types, operators, variables, and other names and constructs.
- **Attributes** ([ReferenceManual/Attributes.md](ReferenceManual/Attributes.md)): Add information to declarations and types.
- **Patterns** ([ReferenceManual/Patterns.md](ReferenceManual/Patterns.md)): Match and destructure values.
- **Generic Parameters and Arguments** ([ReferenceManual/GenericParametersAndArguments.md](ReferenceManual/GenericParametersAndArguments.md)): Generalize declarations to abstract away concrete types.
- **Summary of the Grammar** ([ReferenceManual/SummaryOfTheGrammar.md](ReferenceManual/SummaryOfTheGrammar.md)): Read the whole formal grammar.

### Revision History

- **Document Revision History** ([RevisionHistory/RevisionHistory.md](RevisionHistory/RevisionHistory.md)): Review the recent changes to this book.

## Usage Notes

- Documentation is organized progressively from getting started to advanced topics
- Start with the Introduction or Getting Started section
- Consult specific guides for detailed information

## License & Attribution

This skill contains content converted from DocC documentation format.
