---
name: swift-dependencies
description: A dependency management library for Swift with controlled, testable dependencies
---

# Dependencies

A dependency management library inspired by SwiftUI's "environment."

## Documentation Structure

### Getting started

- **Quick start** ([Articles/QuickStart.md](Articles/QuickStart.md)): Learn the basics of getting started with the library before diving deep into all of its features.
- **What are dependencies?** ([Articles/WhatAreDependencies.md](Articles/WhatAreDependencies.md)): Learn what dependencies are, how they complicate your code, and why you want to control them.

### Essentials

- **Using dependencies** ([Articles/UsingDependencies.md](Articles/UsingDependencies.md)): Learn how to use the dependencies that are registered with the library.
- **Registering dependencies** ([Articles/RegisteringDependencies.md](Articles/RegisteringDependencies.md)): Learn how to register your own dependencies with the library so that they immediately become
- **Live, preview, and test dependencies** ([Articles/LivePreviewTest.md](Articles/LivePreviewTest.md)): Learn how to provide different implementations of your dependencies for use in the live application,
- **Testing** ([Articles/Testing.md](Articles/Testing.md)): One of the main reasons to control dependencies is to allow for easier testing. Learn some tips and

### Advanced

- **Designing dependencies** ([Articles/DesigningDependencies.md](Articles/DesigningDependencies.md)): Learn techniques on designing your dependencies so that they are most flexible for injecting into
- **Overriding dependencies** ([Articles/OverridingDependencies.md](Articles/OverridingDependencies.md)): Learn how dependencies can be changed at runtime so that certain parts of your application can use
- **Dependency lifetimes** ([Articles/Lifetimes.md](Articles/Lifetimes.md)): Learn about the lifetimes of dependencies, how to prolong the lifetime of a dependency, and how
- **Single entry point systems** ([Articles/SingleEntryPointSystems.md](Articles/SingleEntryPointSystems.md)): Learn about "single entry point" systems, and why they are best suited for this dependencies

### Dependency management


## Usage Notes

- Documentation is organized progressively from getting started to advanced topics
- Start with the Introduction or Getting Started section
- Consult specific guides for detailed information

## License & Attribution

This skill contains content converted from DocC documentation format.
