---
name: swift-navigation
description: A collection of tools for making navigation in Swift applications more ergonomic and powerful across SwiftUI, UIKit, and AppKit
---

# Swift Navigation

Tools for making Swift navigation ergonomic across all Apple platforms.

## Modules

This skill contains documentation for multiple modules:

### SwiftNavigation (Core)

Core navigation primitives used by all platform-specific modules.

- [SwiftNavigation/SKILL.md](SwiftNavigation/SKILL.md) - Core module overview
- [SwiftNavigation/Articles/WhatIsNavigation.md](SwiftNavigation/Articles/WhatIsNavigation.md) - What is navigation?
- [SwiftNavigation/Articles/CrossPlatform.md](SwiftNavigation/Articles/CrossPlatform.md) - Cross-platform navigation
- [SwiftNavigation/Extensions/AlertState.md](SwiftNavigation/Extensions/AlertState.md) - Type-safe alert state
- [SwiftNavigation/Extensions/ConfirmationDialogState.md](SwiftNavigation/Extensions/ConfirmationDialogState.md) - Confirmation dialogs
- [SwiftNavigation/Extensions/UIBinding.md](SwiftNavigation/Extensions/UIBinding.md) - Two-way bindings

### SwiftUINavigation

SwiftUI-specific navigation tools.

- [SwiftUINavigation/SKILL.md](SwiftUINavigation/SKILL.md) - SwiftUI module overview
- [SwiftUINavigation/Articles/Bindings.md](SwiftUINavigation/Articles/Bindings.md) - Optional bindings
- [SwiftUINavigation/Articles/AlertsDialogs.md](SwiftUINavigation/Articles/AlertsDialogs.md) - Alerts and dialogs
- [SwiftUINavigation/Articles/SheetsPopoversCovers.md](SwiftUINavigation/Articles/SheetsPopoversCovers.md) - Sheets, popovers, covers
- [SwiftUINavigation/Articles/Navigation.md](SwiftUINavigation/Articles/Navigation.md) - Navigation tools

### UIKitNavigation

UIKit-specific navigation tools and bindings.

- [UIKitNavigation/SKILL.md](UIKitNavigation/SKILL.md) - UIKit module overview
- [UIKitNavigation/Extensions/UIViewController.md](UIKitNavigation/Extensions/UIViewController.md) - View controller navigation
- [UIKitNavigation/Extensions/UIKitAnimation.md](UIKitNavigation/Extensions/UIKitAnimation.md) - Animation support
- [UIKitNavigation/Extensions/UITextField.md](UIKitNavigation/Extensions/UITextField.md) - Text field bindings
- [UIKitNavigation/Extensions/UISwitch.md](UIKitNavigation/Extensions/UISwitch.md) - Switch bindings

### AppKitNavigation

AppKit-specific navigation tools for macOS.

- [AppKitNavigation/SKILL.md](AppKitNavigation/SKILL.md) - AppKit module overview
- [AppKitNavigation/Extensions/AppKitAnimation.md](AppKitNavigation/Extensions/AppKitAnimation.md) - Animation support

## Usage Notes

- Start with the Core module to understand fundamental concepts
- Use the platform-specific module for your target platform
- AlertState and ConfirmationDialogState work across all platforms

## License & Attribution

This skill contains content converted from DocC documentation format.

