---
name: swift-navigation-swiftui
description: SwiftUI navigation tools: type-safe alerts, sheets, popovers, and navigation destinations
---

# SwiftUINavigation

Tools for making SwiftUI navigation simpler, more ergonomic and more precise.

## Documentation Structure

### Tools

- **SwiftUI navigation** ([Articles/SwiftUINavigationTools.md](Articles/SwiftUINavigationTools.md)): Learn more about SwiftUI's tools for navigations, and how this library improves upon them.
- **Navigation links and destinations** ([Articles/Navigation.md](Articles/Navigation.md)): Learn how to drive navigation in `NavigationView` and `NavigationStack` in a concise and testable
- **Sheets, popovers, and covers** ([Articles/SheetsPopoversCovers.md](Articles/SheetsPopoversCovers.md)): Learn how to present sheets, popovers and covers in a concise and testable manner.
- **Alerts and dialogs** ([Articles/AlertsDialogs.md](Articles/AlertsDialogs.md)): Learn how to present alerts and confirmation dialogs in a concise and testable manner.
- **Bindings** ([Articles/Bindings.md](Articles/Bindings.md)): Learn how to manage certain view state, such as `@FocusState` directly in your observable classes.

## Usage Notes

- Documentation is organized progressively from getting started to advanced topics
- Start with the Introduction or Getting Started section
- Consult specific guides for detailed information

## License & Attribution

This skill contains content converted from DocC documentation format.
