---
name: swift-snapshot-testing
description: A library for snapshot testing in Swift with support for views, images, and custom formats
---

# SnapshotTesting

Powerfully flexible snapshot testing.

## Documentation Structure

### Essentials

- **Integrating with test frameworks** ([Articles/IntegratingWithTestFrameworks.md](Articles/IntegratingWithTestFrameworks.md)): Learn how to use snapshot testing in the two main testing frameworks: Xcode's XCTest and Swift's
- **Migration guides** ([Articles/MigrationGuides/MigrationGuides.md](Articles/MigrationGuides/MigrationGuides.md)): Learn how to upgrade your application to the newest version of this library.

### Strategies

- **Defining custom snapshot strategies** ([Articles/CustomStrategies.md](Articles/CustomStrategies.md)): While SnapshotTesting comes with a wide variety of snapshot strategies, it can also be extended with

### Configuration


### Deprecations

- **Deprecations** ([Extensions/Deprecations/SnapshotTestingDeprecations.md](Extensions/Deprecations/SnapshotTestingDeprecations.md))

## Usage Notes

- Documentation is organized progressively from getting started to advanced topics
- Start with the Introduction or Getting Started section
- Consult specific guides for detailed information

## License & Attribution

This skill contains content converted from DocC documentation format.
