---
name: validating-startup-ideas
description: "Find and validate startup ideas by mining user complaints, crafting premises, and navigating the idea maze. Use when discovering product opportunities, validating ideas, shaping solutions, researching user pain points, or exploring what to build."
metadata:
  author: nweii
  version: "1.6.0"
---

# Validating Startup Ideas

Apply these frameworks as lenses to what the user brings—use them to surface blindspots, ask sharper questions, or reframe what's being worked on. This skill works at any stage of idea maturity.

Every complaint signals someone willing to pay for a better solution. But finding complaints is only the start—great products give users a **premise** that normalizes new behavior.

## Finding problems

Mine complaints from platforms where users express frustration:

| Product type | Source                         | Search for                                            |
| ------------ | ------------------------------ | ----------------------------------------------------- |
| B2B          | G2, Capterra (1-2★ reviews)    | "doesn't have", "wish it could", "missing", "can't"   |
| B2C services | Reddit + "[topic] frustrating" | r/mildlyinfuriating, niche hobby subs, r/entrepreneur |
| Automation   | Upwork job posts               | "weekly", "monthly", "ongoing", "repeat"              |
| Mobile apps  | App Store 1★ reviews           | Same complaint 20+ times                              |

**Reddit**: Sort by comments, not upvotes. High comments = heated debate = real problem.

**Upwork**: If 100+ people paying $20/hr for a task, they'll pay $50/mo to automate it.

## Evaluating ideas

From Lenny Rachitsky's B2B framework—four signs your idea has legs:

1. **Payment**: Strangers pay you money (not just friends/connections)
2. **Retention**: Continued usage despite hacky MVP
3. **Emotion**: Hatred for incumbents or strong pull toward your idea
4. **Inbound**: Cold interest without marketing

Quick validation checklist:

- 30+ people with same complaint
- Already paying for inferior alternative
- Existing solution has obvious flaw

### Tarpit detection

Dalton Caldwell (YC): Tarpits are ideas that _seem_ promising, validate easily, and attract lots of founders—but systematically fail. Classic examples: "apps to coordinate hangouts with friends," music discovery, Foursquare clones. Warning signs:

- Everyone you tell says "I would use that"
- You can name 5+ attempts at the same idea
- The problem has existed forever without a dominant solution

### Adjacent users

Bangaly Kaba (Instagram, Instacart): Consider who's _just outside_ your current user base. The "adjacent user" is someone who could use your product but doesn't—often because of a single friction point. When you solve for them, you unlock the next growth wave.

## Shaping the solution

Don't build what users ask for. Solve the underlying problem better.

**Bad**: "Notion is too complex" → simpler Notion clone  
**Good**: "Notion is too complex" → focused tool for one specific use case

Great products give users a **premise**—a foundational belief that normalizes otherwise-atypical actions:

- **Airbnb**: It's ok to stay in strangers' homes
- **Bumble**: It's ok for women to ask men out
- **Substack**: It's ok to charge for your writing
- **Kickstarter**: It's ok to ask for money before building

The best premises become core features. Bumble required women to message first—the premise became the product mechanic.

### Sugar-coated broccoli

Ivan Zhao (Notion): If your vision is "broccoli" (something users don't naturally seek out), wrap it in "sugar" (a form factor they already use daily). Notion wanted to build "Lego for software"—but nobody wakes up wanting that. So they hid it inside productivity software, a category people already cared about. The vision is still there; it's just discovered gradually.

### Force a choice, not a comparison

Mike Maples Jr (Floodgate): Don't be a "10x better Apple." Be the world's first banana. Great ideas make people choose you or not—they can't compare you to the status quo. If customers can substitute something else for your solution, they won't take the risk on a startup.

**For deeper guidance on crafting premises and shaping ideas strategically**, see [references/shaping-ideas.md](references/shaping-ideas.md).

## Testing early

Fons Mans approach:

1. Write it down, sleep on it
2. Mention casually in conversation
3. If positive reaction → 30-min visual concept
4. Quick check with new people (genuine reaction, no pitch)
5. Publish to wider audience
6. Only then build the leanest possible version

From Paul Graham: Real startups discover the problem through evolution. Operate cheaply. Let ideas evolve. The market doesn't care how hard you worked—only whether you built what users want.
