# Shaping Ideas Strategically

Deeper guidance on moving from validated problems to compelling products.

## The premise framework

A premise is a foundational belief that shapes user behavior by normalizing actions people otherwise wouldn't take, held back by existing norms.

### How premises work

Premises are powerful because many desirable actions feel weird, taboo, or risky. Products that succeed often give users _permission_ to do something they secretly want to do.

**Airbnb**: Staying in strangers' homes was doubted even by the founders. It might be seen as weird, taboo, or dangerous. Airbnb's premise normalized it.

**Bumble**: Made the premise the core mechanic—women _must_ message first. The premise became the product's differentiating feature and marketing hook.

**Substack**: Aimed to normalize the hardest part of internet writing: getting paid. Made the less-hard parts even easier (start free, go paid when ready). This lowered the barrier to getting started while normalizing the end goal.

### Where premises work best

Premises work best on:

- End consumers
- Prosumers
- Small business / freelancers
- Two-sided marketplaces serving these groups

### Crafting a premise

Ask: What behavior does your product enable that users might feel hesitant about? What norm are you helping them break?

Format: "It's ok to [action that feels socially risky]"

Examples beyond the classics:

- **Notion**: It's ok to build your own tools without coding
- **Figma**: It's ok for everyone to participate in design
- **Calendly**: It's ok to ask others to book time on your terms

## Software abstractions as worldview

From Linus Lee: Software gives you its own set of abstractions and vocabulary to understand experience. Software's worldview is about:

- Abstractions modeling underlying complexity
- Signal vs. noise
- Scale and orders of magnitude
- Information—how much, what to do with it, how to learn from it

The people who write software see the world through this lens. Understanding this worldview may be more valuable than learning to wield programming tools.

**For idea validation**: Consider what abstraction your product offers. What complexity does it hide? What new vocabulary does it give users?

## Inflections and earned secrets

From Mike Maples Jr (Floodgate): Pattern-breaking ideas sit at the intersection of *inflections* and *insights*.

**Inflections** are external events that create the potential for radical change—technological (iPhone 4s GPS chip), regulatory (telemedicine across state lines), or belief-based (people trusting reviews over hotel brands). They happen outside any single company and create windows of opportunity.

**Earned secrets** are non-obvious truths about how inflections can be harnessed to change behavior. They're *earned* by living in the future—getting your hands dirty with cutting-edge technology, not just reading about it. If you're not living in the future, your opinion about it isn't valid.

Stress test your inflection:
1. What specifically is the new thing?
2. What specific empowerment does it offer, to whom?
3. What conditions must be met for that empowerment to be realized?

The insight comes from noticing what's *missing* in the future you're living in. The Airbnb guys didn't know air bed and breakfast was a startup idea at first—they were just trying to pay rent. The insight emerged from playing in a new space and being surprised.

## The idea maze

From Chris Dixon: Good founders can anticipate how their industry and competitors may change to find success over many potential paths.

### Navigation tools

When starting out, you can't completely map the maze. But look for help in:

**History**: If your idea has been tried before (almost all good ideas have), figure out what previous attempts did right and wrong. A lot of this knowledge exists only in practitioners' brains—one reason "stealth mode" is a bad idea. Benefits of learning the maze far outweigh risks of idea theft.

**Analogy**: Build the maze by analogy to similar businesses.

- Building a peer economy company? Study what Airbnb did right.
- Building a marketplace? Understand eBay's beginnings.

## The evolution philosophy

From Paul Graham:

**Organic ideas don't look like startup ideas at first.** Facebook in 2004—putting undergraduates' profiles online—wouldn't have seemed like a startup idea. It wasn't initially one. Same with Apple I. If these founders had thought they were starting companies, they might have been tempted to do something more "serious," and that would have been a mistake.

**Real startups discover problems through evolution.** Someone has an idea, builds it, and only by doing so realizes the problem they should be solving is another one.

**Operate cheaply and give ideas time to evolve.** The worst thing is a rigid, pre-ordained plan with heavy spending to implement it.

**The key skill isn't technical—it's understanding users.** Get into the habit of thinking of software as having users. What do they want? What would make them say wow?

### The value-business balance

Ivan Zhao (Notion): "Too much of yourself, then there's no users—you're just doing an art project. Too much for business, you're building a commodity." Great products exist on a spectrum between building for your values and building for the market. Neither extreme works.

PMF doesn't feel binary. It's gradual—"Oh, good. We have people who care about this thing we make now." No milestone moment, just slowly strengthening signal.

### Don't be afraid to reset

"You can create progress through better abstractions. That compounds faster, can catch up to all the things you built much quicker than you ever thought." Humans think linearly; abstractions compound exponentially. If you find a better way, you can recover sunk costs surprisingly fast.

## Hallmarks of a great idea

From Paddy Galloway:

- Interesting to core, casual, and new audiences
- Easy to convey in a title and thumbnail
- Has unique/novelty value
- Combines 1+ viral formats together
- Friends get excited when you mention it

## The right question

From Visakan Veerasamy:

"How can I afford an expensive shot at entrepreneurship?" is the wrong question.

"How can I help people and solve problems as cheaply as possible?" is better.

Do this well enough, long enough, and people will start giving you bigger opportunities and responsibilities.
