---
name: exploring-codebases
description: Semantic search for codebases. Locates matches with ripgrep and expands them into full AST nodes (functions/classes) using tree-sitter or pre-generated _MAP.md files. Returns complete, syntactically valid code blocks rather than fragmented lines. Use when looking for specific implementations, examples, or references where full context is needed.
metadata:
  version: 0.3.1
---

# Exploring Codebases

Hybrid search tool that combines the speed of `ripgrep` with structural awareness from `tree-sitter` or pre-generated `_MAP.md` files. It finds matches and returns the *entire* function or class containing the match, de-duplicating results semantically.

## Progressive Disclosure

**By default, returns signatures only** (docstrings + declarations without function bodies), reducing token usage by 10-20x. Use `--expand-full` to get complete implementations when needed.

## Installation

```bash
uv venv /home/claude/.venv
# tree-sitter is optional if using --use-maps mode
uv pip install tree-sitter-language-pack --python /home/claude/.venv/bin/python
```

## Usage

```bash
# Default: signatures only with tree-sitter (efficient)
/home/claude/.venv/bin/python /mnt/skills/user/exploring-codebases/scripts/search.py "query" /path/to/repo

# Full implementations
/home/claude/.venv/bin/python /mnt/skills/user/exploring-codebases/scripts/search.py "query" /path/to/repo --expand-full

# Map-based mode: no tree-sitter required (#276)
# Requires _MAP.md files generated by mapping-codebases
/home/claude/.venv/bin/python /mnt/skills/user/exploring-codebases/scripts/search.py "query" /path/to/repo --use-maps
```

## Options

- `--glob pattern`: Filter files (e.g., `*.py`, `*.ts`)
- `--expand-full`: Return full implementations instead of signatures
- `--json`: Output JSON for machine processing (default is Markdown)
- `--use-maps`: Use pre-generated `_MAP.md` files instead of tree-sitter for context expansion. Eliminates redundant tree-sitter parsing when maps already exist.

## Map-Based Mode (v0.3.0)

When `_MAP.md` files exist (generated by `mapping-codebases`), use `--use-maps` to skip tree-sitter entirely:

1. `mapping-codebases` runs tree-sitter once to generate `_MAP.md` files with symbol locations
2. `exploring-codebases --use-maps` uses ripgrep + map data for context expansion
3. No redundant AST parsing at search time

**Benefits:**
- Single tree-sitter execution per codebase (during map generation)
- Faster searches (no AST parsing overhead)
- `tree-sitter-language-pack` not required at runtime
- Maps serve as canonical index for both navigation and search

**Recommended workflow:**
```bash
# Step 1: Generate maps (one-time, or after code changes)
python /mnt/skills/user/mapping-codebases/scripts/codemap.py /path/to/repo

# Step 2: Search using maps (fast, no tree-sitter needed)
python /mnt/skills/user/exploring-codebases/scripts/search.py "query" /path/to/repo --use-maps
```

## Examples

**Find class signatures:**
```bash
/home/claude/.venv/bin/python /mnt/skills/user/exploring-codebases/scripts/search.py "class User" /path/to/repo
```

Output:
```python
class User:
    """User account model."""
    ...
```

**Find full method implementation:**
```bash
/home/claude/.venv/bin/python /mnt/skills/user/exploring-codebases/scripts/search.py "def validate" /path/to/repo --expand-full
```

**Find usage of `process_data` in Python files:**
```bash
/home/claude/.venv/bin/python /mnt/skills/user/exploring-codebases/scripts/search.py "process_data" /path/to/repo --glob "*.py"
```

## Scope and Limitations

**Returns structural code elements** — functions, classes, methods, interfaces, enums, structs, traits, and modules across 11 supported languages (Python, JavaScript, TypeScript, Go, Rust, Ruby, Java, C, C++, PHP, C#).

**Does not return:**
- Import/require statements
- Module-level variable assignments or constants
- Standalone decorators (decorators attached to functions/classes are included with their parent)
- Type aliases or standalone type annotations
- Comments outside of functions/classes

For these non-structural elements, use plain `ripgrep` (via the Grep tool) directly.
