# 品牌视觉规范默认值

当用户未提供品牌规范时使用的默认极简风格参数。

## 核心配色

```yaml
背景:
  纯黑: "#000000"  # 所有页面统一

品牌强调:
  荧光绿: "#00FF94"  # 页码、强调、数据、链接

文字:
  主文字: "#FFFFFF"  # 标题和重要内容
  次要: "#CCCCCC"    # 描述和说明
  弱化: "#808080"    # 注释和辅助

禁用颜色:
  - 任何蓝色系
  - 任何渐变色
  - 过于鲜艳的颜色
```

## 色彩使用比例

```
黑色背景: 60-65%
白色内容: 25-30%
强调色: 3-5% ← 黄金比例，克制使用
```

## 字体层级

```yaml
H0_页码:
  字号: 96pt
  字重: Bold
  颜色: "#00FF94"
  字体: 等宽字体 (Courier New / SF Mono)

H1_页面标题:
  字号: 42pt
  字重: Bold
  颜色: "#FFFFFF"

H2_一级内容:
  字号: 32pt
  字重: Bold
  颜色: "#FFFFFF"

H3_二级标题:
  字号: 28pt
  字重: SemiBold
  颜色: "#FFFFFF" 或 "#00FF94"

Body_正文:
  字号: 20pt
  字重: Regular
  颜色: "#CCCCCC"
  行高: 1.6倍

Note_注释:
  字号: 14pt
  字重: Regular
  颜色: "#808080"
```

## 页面布局

```yaml
画布规格:
  比例: 16:9
  尺寸: 1920×1080px

边距系统:
  外边距: 60px (上下左右)
  安全区: 80px (内容到边缘最小距离)

留白目标: 55-60%

网格系统:
  基础单位: 8px
  常用间距: 8, 16, 24, 32, 48, 64
```

## 页码规范

```yaml
位置: 左上区域
  距顶: 15%
  距左: 10%

装饰线:
  宽度: 150px
  高度: 1px
  颜色: "#00FF94"
  位置: 页码上方

格式: 01, 02, 03... (两位数补零)
```

## 底部标识

```yaml
左下:
  内容: "[品牌标语]" 或留空
  字体: 14pt Regular
  颜色: "#CCCCCC"
  距左: 60px
  距底: 40px

右下:
  内容: "[品牌域名]" 或留空
  字体: 14pt Bold
  颜色: "#00FF94"
  距右: 80px
  距底: 40px
```

## 视觉元素规范

```yaml
允许使用:
  - 极简几何: 方形、圆形、线条
  - 代码符号: {} <> // () []
  - 箭头: → ↓ ⇒ (使用强调色)
  - 状态符号: ✓ ✗ ◆
  - Emoji: 适量使用 (每个卡片最多1个)

严格禁止:
  - 复杂插画
  - 渐变色
  - 3D效果
  - 过度阴影
  - 多彩图标
  - 像素粒子效果
```

## 容器样式

```yaml
卡片:
  背景: "#0F0F1F" 或 "#1A1A1A"
  边框: 1px #3A3A3A
  圆角: 4-6px
  内边距: 16-32px

强调框:
  背景: "rgba(0,255,148,0.1)"
  边框: 2px #00FF94
  圆角: 4px
  阴影: "0 8px 24px rgba(0,255,148,0.15)"

分隔线:
  高度: 1px
  颜色: "#3A3A3A" 或 "#00FF94"
```
