# 输出格式模板

完整的PPT设计方案输出结构和单页设计模板。

## 完整输出结构

```markdown
# 📊 《[项目标题]》完整PPT设计方案

---

## 📋 项目概览

| 项目 | 信息 |
|-----|-----|
| 项目标题 | [从内容提取] |
| 目标受众 | [开发者/技术主管/...] |
| 演讲时长 | [X-X分钟] |
| 总页数 | [N]页 |
| 设计风格 | [极简/科技/品牌名] |
| 品牌标语 | [如有] |
| 官网标识 | [如有] |

---

## 🎨 品牌视觉规范摘要

[从品牌规范或默认值提取关键信息]

### 配色
- 背景: #000000
- 强调: #00FF94
- 主文字: #FFFFFF
- 次要: #CCCCCC

### 字体层级
- 页码: 96pt Bold 等宽
- 标题: 42pt Bold
- 内容: 32pt Bold
- 正文: 20pt Regular

---

## 📄 完整[N]页设计方案

[每页详细设计...]

---

## 🎬 跨页面连贯性规范

### 视觉统一性
- [ ] 所有页面使用相同背景色
- [ ] 页码位置和样式一致
- [ ] 底部标识位置固定
- [ ] 字体层级全局统一

### 内容递进
- [ ] 主题从抽象到具体
- [ ] 强调程度逐渐递增
- [ ] 色彩使用有节奏感

---

## 📊 质量检查清单

### 品牌规范检查
- [ ] 所有页面背景统一
- [ ] 页码格式正确 (01, 02, 03...)
- [ ] 底部标识位置正确
- [ ] 强调色使用面积≤5%

### 设计规范检查
- [ ] 所有间距都是8px的倍数
- [ ] 留白比例达到55-60%
- [ ] 没有使用渐变色或3D效果
- [ ] 字体种类不超过2种

### 内容检查
- [ ] 每页只有一个核心观点
- [ ] Emoji使用适量（每页最多2个）
- [ ] 页面间有视觉连贯性

### 输出检查
- [ ] 包含ASCII布局示意图
- [ ] 包含YAML格式精确参数
- [ ] 参数精确到可直接执行
```

## 单页设计模板

```markdown
### Page [XX] - [页面标题]「[页码显示]」

#### 💡 设计思路

| 维度 | 内容 |
|-----|-----|
| 目标 | [这一页3秒内要传达什么] |
| 策略 | [采用什么视觉策略] |
| 视觉形式 | [箭头流程/并列卡片/金字塔/竖线列表/居中引用/数据强调] |

#### 📐 布局结构

```
┌────────────────────────────────────────────────┐
│  ──────────                                    │
│  [页码]                                        │
│                                               │
│  [页面标题]                                    │
│                                               │
│         [核心内容区布局示意图]                  │
│                                               │
│                                               │
│  [左下标识]                        [右下标识]   │
└────────────────────────────────────────────────┘
```

#### 🎯 精确设计参数

**【页码区】**
```yaml
装饰线:
  宽度: 150px
  高度: 1px
  颜色: "#00FF94"
  位置: "距顶80px, 距左80px"

页码:
  内容: "[XX]"
  字体: "96pt Bold Courier New"
  颜色: "#00FF94"
  位置: "装饰线下方24px"
```

**【标题区】**
```yaml
主标题:
  内容: "[具体文字]"
  字体: "42pt Bold"
  颜色: "#FFFFFF"
  位置: "页码右方, 顶部对齐"
  距左: 240px
```

**【核心内容区】**
```yaml
# 根据选择的视觉形式填写
# 参考 visual-forms.md 中的对应模板

布局类型: "[视觉形式类型]"
对齐: "[对齐方式]"

# [具体内容参数...]
```

**【底部标识】**
```yaml
左下:
  内容: "[品牌标语]"
  字体: "14pt Regular"
  颜色: "#CCCCCC"
  位置: "距左60px, 距底40px"

右下:
  内容: "[品牌域名]"
  字体: "14pt Bold"
  颜色: "#00FF94"
  位置: "距右80px, 距底40px"
```
```

## 特殊页面模板

### 标题页模板

```markdown
### Page 01 - 标题页

#### 📐 布局结构

```
┌────────────────────────────────────────────────┐
│                                               │
│                                               │
│                                               │
│              [主标题]                          │
│              [副标题]                          │
│                                               │
│                                               │
│                                               │
│  [左下标识]                        [右下标识]   │
└────────────────────────────────────────────────┘
```

#### 🎯 精确设计参数

```yaml
主标题:
  内容: "[标题文字]"
  字体: "54pt Bold"
  颜色: "#FFFFFF"
  对齐: "水平居中, 垂直居中偏上"

副标题:
  内容: "[副标题文字]"
  字体: "24pt Regular"
  颜色: "#CCCCCC"
  距主标题: 24px

品牌元素(可选):
  Logo: "[如有]"
  位置: "主标题上方 或 右上角"
```
```

### 总结页模板

```markdown
### Page [N] - 总结页

#### 📐 布局结构

```
┌────────────────────────────────────────────────┐
│  ──────────                                    │
│  [页码]                                        │
│                                               │
│               💡 [小标题]                      │
│            ───────────────                    │
│                                               │
│           "[核心金句]"                         │
│                                               │
│                [行动号召]                       │
│                                               │
│  [左下标识]                        [右下标识]   │
└────────────────────────────────────────────────┘
```

#### 🎯 精确设计参数

```yaml
金句区:
  Emoji: "44pt"
  小标题: "22pt Bold #00FF94"
  分隔线: "200px宽, 1px #00FF94"
  金句: "32pt Bold #FFFFFF, 行高1.4"

行动号召(可选):
  内容: "[具体行动]"
  字体: "20pt Regular"
  颜色: "#CCCCCC"
  样式: "链接用荧光绿"
```
```
