# 视觉形式设计库

详细的PPT视觉形式参数模板，按内容类型组织。

## 形式1: 箭头流程（对比/演进）

适用于：状态变化、流程演进、对比展示

```
┌─────────────────────────────────────────┐
│                                         │
│   [状态A]  ──→  [状态B]  ──→  [状态C]   │
│     ↑            ↑            ↑        │
│   弱化         过渡         强调       │
│  #808080     #CCCCCC      #00FF94     │
│                                         │
└─────────────────────────────────────────┘
```

参数模板：
```yaml
布局类型: horizontal_flow
对齐: 水平居中, 垂直居中

状态框:
  宽度: 160-200px
  高度: 80-100px
  背景: "#1A1A1A"
  圆角: 4px
  内边距: 16px 24px

连接箭头:
  符号: "→"
  颜色: "#00FF94"
  长度: 80-120px
  线宽: 3px

元素间距: 48px

强调递进:
  第一项: 边框1px#808080, 文字#808080
  第二项: 边框1px#CCCCCC, 文字#CCCCCC
  第三项: 边框2px#00FF94, 文字#00FF94, 背景荧光绿10%透明
```

## 形式2: 三列卡片（并列展示）

适用于：特点列举、选项对比、功能展示

```
┌─────────────────────────────────────────┐
│                                         │
│  ┌─────────┐ ┌─────────┐ ┌─────────┐   │
│  │  🎮     │ │  💻     │ │  🤖     │   │
│  │  标题   │ │  标题   │ │  标题   │   │
│  │ < 1小时 │ │  零报错 │ │ 深度反思│   │
│  │  说明   │ │  说明   │ │  说明   │   │
│  └─────────┘ └─────────┘ └─────────┘   │
│                                         │
└─────────────────────────────────────────┘
```

参数模板：
```yaml
布局类型: card_grid
列数: 3
对齐: 水平居中

卡片:
  宽度: 320px
  高度: 280-420px
  背景: "#0F0F1F"
  边框: 1px #3A3A3A
  圆角: 6px
  内边距: 32px 24px

卡片间距: 32px

内容层级:
  Emoji: 48pt 居中
  标题: 24pt Bold #FFFFFF
  数据: 36pt Bold #00FF94
  说明: 16pt Regular #CCCCCC
  
内部间距:
  Emoji到标题: 24px
  标题到数据: 16px
  数据到说明: 12px
```

## 形式3: 金字塔递进（层级关系）

适用于：阶段递进、重要性排序、能力层级

```
┌─────────────────────────────────────────┐
│                                         │
│        ┌─────────────────┐              │
│        │  合（融合阶段）  │  ← 强调     │
│        └─────────────────┘              │
│      ┌─────────────────────┐            │
│      │  驭（助手阶段）     │  ← 过渡    │
│      └─────────────────────┘            │
│    ┌─────────────────────────┐          │
│    │  用（工具阶段）         │  ← 弱化  │
│    └─────────────────────────┘          │
│                                         │
└─────────────────────────────────────────┘
```

参数模板：
```yaml
布局类型: pyramid
对齐: 水平居中
堆叠方式: 重叠式(overlap 24px)

层级配置:
  底层:
    宽度: 700px
    边框: 1px #808080
    背景: "#0A0A0A"
    标题颜色: "#CCCCCC"
    
  中层:
    宽度: 620px
    边框: 2px #CCCCCC
    背景: "rgba(0,255,148,0.12)"
    标题颜色: "#FFFFFF"
    
  顶层:
    宽度: 540px
    边框: 3px #00FF94
    背景: "rgba(0,255,148,0.15)"
    标题颜色: "#00FF94"

层高: 80px
层间距: -24px (重叠)
```

## 形式4: 左侧竖线+菱形列表（维度展示）

适用于：要点罗列、维度分析、特性说明

```
┌─────────────────────────────────────────┐
│                                         │
│    │ ◆ 责任归属                         │
│    │   AI无法承担法律责任               │
│    │                                    │
│    │ ◆ 价值判断                         │
│    │   判断功能是否满足需求             │
│    │                                    │
│    │ ◆ 创新创意                         │
│    │   跨域思维与情感共鸣               │
│                                         │
└─────────────────────────────────────────┘
```

参数模板：
```yaml
布局类型: vertical_list
对齐: 左对齐

竖线:
  宽度: 3px
  颜色: "#00FF94"
  距左: 12%
  高度: 自适应内容

菱形符号:
  符号: "◆"
  字号: 20pt
  颜色: "#00FF94"
  距竖线: 24px

标题:
  字号: 28pt Bold
  颜色: "#FFFFFF"
  距菱形: 16px

描述:
  字号: 18pt Regular
  颜色: "#CCCCCC"
  最大宽度: 600px
  距标题: 8px

维度间距: 56px
```

## 形式5: 居中引用（金句/总结）

适用于：核心观点、金句展示、号召行动

```
┌─────────────────────────────────────────┐
│                                         │
│               💡 核心金句               │
│            ───────────────              │
│                                         │
│           "技术可以外包                 │
│     判断、责任、创新永远属于人"         │
│                                         │
│                                         │
└─────────────────────────────────────────┘
```

参数模板：
```yaml
布局类型: centered_quote
对齐: 完全居中

小标题:
  Emoji: 44pt
  文字: 22pt Bold #00FF94
  间距: 16px

分隔线:
  宽度: 200px
  高度: 1px
  颜色: "#00FF94"
  距小标题: 24px

金句:
  字号: 32pt Bold
  颜色: "#FFFFFF"
  行高: 1.4
  最大宽度: 800px
  距分隔线: 32px

引用框(可选):
  背景: "rgba(0,255,148,0.05)"
  边框: 2px #00FF94
  圆角: 4px
  内边距: 20px 40px
  阴影: "0 8px 24px rgba(0,255,148,0.12)"
```

## 形式6: 大数字强调（数据展示）

适用于：关键数据、成果展示、统计信息

```
┌─────────────────────────────────────────┐
│                                         │
│                 95%                     │
│           准确率提升                    │
│                                         │
│    ┌──────┐  ┌──────┐  ┌──────┐        │
│    │ 3x   │  │ 50%  │  │ 24/7 │        │
│    │ 效率 │  │ 成本 │  │ 服务 │        │
│    └──────┘  └──────┘  └──────┘        │
│                                         │
└─────────────────────────────────────────┘
```

参数模板：
```yaml
布局类型: data_highlight
对齐: 水平居中

主数据:
  数字: 96pt Bold #00FF94
  说明: 24pt Regular #FFFFFF
  间距: 16px

副数据组:
  容器: 横向排列
  数字: 48pt Bold #FFFFFF
  说明: 16pt Regular #CCCCCC
  
副数据卡片:
  宽度: 180px
  背景: "#0F0F1F"
  边框: 1px #3A3A3A
  内边距: 24px 16px
  
卡片间距: 24px
主副间距: 64px
```
