# CLI Development Guidelines

Design and review command-line interfaces with human-first UX and UNIX composability.

## What's included

- **SKILL.md** — Core methodology for CLI design
- **references/** — Deep-dive reference material and checklists
- **templates/** — JSON spec template, help text skeleton, error message patterns
- **scripts/cli_audit.py** — Automated CLI citizenship checker

## Attribution

This skill is adapted primarily from [Command Line Interface Guidelines](https://clig.dev/) (CC BY-SA 4.0):
- Authors: Aanand Prasad, Ben Firshman, Carl Tashian, Eva Parish
- Design: Mark Hurrell
- Repository: <https://github.com/cli-guidelines/cli-guidelines>

Additional sources:
- [POSIX Utility Conventions](https://pubs.opengroup.org/onlinepubs/9699919799/basedefs/V1_chap12.html)
- [GNU Coding Standards](https://www.gnu.org/prep/standards/)
- [Heroku CLI Style Guide](https://devcenter.heroku.com/articles/cli-style-guide)
- [12 Factor CLI Apps](https://medium.com/@jdxcode/12-factor-cli-apps-dd3c227a0e46)
- [NO_COLOR convention](https://no-color.org/)
- [XDG Base Directory Spec](https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html)

## License

**Documentation** (SKILL.md, references/, templates/*.md): [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/)

**Scripts** (scripts/): MIT License

```
MIT License

Copyright (c) 2025

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```
