# Signal Types for Pattern Recognition

Detailed taxonomy of signals to watch for when identifying patterns.

## Success Signals

Indicators that a pattern is working well:

| Signal | What to Look For | Evidence |
|--------|------------------|----------|
| **Completion markers** | Task finished smoothly, no backtracking | Clean execution, no rework |
| **Positive feedback** | Confirmation of value or effectiveness | User satisfaction, explicit praise |
| **Repetition** | Same approach used 3+ times | Consistent application across contexts |
| **Efficiency** | Solved problem faster/cleaner | Time savings, reduced complexity |

### Recognizing Success

- Task completes without pivots
- Solution reused without modification
- Positive outcomes compound over time
- Others adopt the approach

## Frustration Signals

Indicators of anti-patterns or problematic approaches:

| Signal | What to Look For | Evidence |
|--------|------------------|----------|
| **Backtracking** | Undoing previous work | Multiple reverts, starting over |
| **Clarification loops** | Multiple rounds to understand | Repeated questions, misalignment |
| **Rework** | Implementing then replacing | Wasted effort, duplicated work |
| **Confusion markers** | Misalignment between expectation and outcome | Surprise, disappointment |

### Recognizing Frustration

- Repeated failed attempts at same approach
- Escalating complexity without progress
- Tension between expectation and result
- Time spent exceeds value delivered

## Workflow Signals

Indicators of procedural patterns:

| Signal | What to Look For | Evidence |
|--------|------------------|----------|
| **Sequence consistency** | Same steps in same order | Repeatable process |
| **Decision points** | Recurring choices at specific moments | Branch logic, conditionals |
| **Quality gates** | Checkpoints before proceeding | Validation steps, reviews |
| **Exit conditions** | How completion is determined | Clear done criteria |

### Recognizing Workflow Patterns

- Steps always occur in same sequence
- Specific conditions trigger specific actions
- Consistent validation before advancement
- Clear definition of "done"

## Orchestration Signals

Indicators of coordination patterns:

| Signal | What to Look For | Evidence |
|--------|------------------|----------|
| **Multi-component coordination** | Multiple parts working together | Integration points |
| **State management** | Tracking across sub-tasks | Shared context, handoffs |
| **Routing logic** | Work directed based on conditions | Conditional branching |
| **Aggregation** | Results combined from sources | Merge points, synthesis |

## Signal Quality Assessment

Not all signals are equal. Assess:

**Strong signals**:
- Repeated observation (3+ times)
- Clear cause-effect relationship
- Consistent across contexts
- Objectively measurable

**Weak signals**:
- Single occurrence
- Correlation without causation
- Context-dependent
- Subjective interpretation

Require strong signals before codifying patterns.
