# Migration Audit Report

**Project:** {{PROJECT_NAME}}
**Date:** {{DATE}}
**Generated by:** `@outfitter/migrate init`

## Summary

| Category | Count | Files |
|----------|-------|-------|
| Exceptions (`throw`) | {{THROW_COUNT}} | {{THROW_FILES}} |
| Try/Catch blocks | {{TRY_CATCH_COUNT}} | {{TRY_CATCH_FILES}} |
| Console logging | {{CONSOLE_COUNT}} | {{CONSOLE_FILES}} |
| Hardcoded paths | {{PATH_COUNT}} | {{PATH_FILES}} |
| Custom error classes | {{ERROR_CLASS_COUNT}} | — |
| Documentation files | {{DOC_COUNT}} | — |
| **Unknowns** | {{UNKNOWN_COUNT}} | — |

## Estimated Effort

| Stage | Scope | Effort |
|-------|-------|--------|
| Foundation | Setup | Low |
| Handlers | {{HANDLER_COUNT}} functions | {{HANDLER_EFFORT}} |
| Errors | {{ERROR_CLASS_COUNT}} classes | {{ERROR_EFFORT}} |
| Paths | {{PATH_COUNT}} usages | {{PATH_EFFORT}} |
| Adapters | {{ADAPTER_COUNT}} commands/tools | {{ADAPTER_EFFORT}} |
| Documents | {{DOC_COUNT}} files | {{DOC_EFFORT}} |
| Unknowns | {{UNKNOWN_COUNT}} items | Review required |

## Dependencies to Add

```bash
bun add @outfitter/contracts @outfitter/logging @outfitter/config
```

Optional:
```bash
bun add @outfitter/cli      # If building CLI
bun add @outfitter/mcp      # If building MCP server
bun add @outfitter/file-ops # If file operations with path security
bun add @outfitter/daemon   # If building background services
```

## Migration Plan

See [plan/](./plan/) for stage-by-stage breakdown:

1. [Foundation](./plan/01-foundation.md) — Dependencies, context, logger
2. [Handlers](./plan/02-handlers.md) — Convert to Result-returning handlers
3. [Errors](./plan/03-errors.md) — Map to error taxonomy
4. [Paths](./plan/04-paths.md) — XDG-compliant paths
5. [Adapters](./plan/05-adapters.md) — CLI/MCP transport layers
6. [Documents](./plan/06-documents.md) — Update documentation
7. [Unknowns](./plan/99-unknowns.md) — Items requiring review

## Next Steps

1. Review this report for accuracy
2. Adjust priorities in [00-overview.md](./plan/00-overview.md)
3. Begin with Stage 1 (Foundation)
