# Serious Adverse Event (SAE) Report Template

## Report Information

**Report Type:** [ ] Initial Report  [ ] Follow-up Report  [ ] Final Report  
**Report Number:** [SAE-YYYY-####]  
**Report Date:** [MM/DD/YYYY]  
**Reporter:** [Name and title]  
**Reporter Contact:** [Email and phone]

**Follow-up Number:** [If follow-up: #1, #2, etc.]  
**Previous Report Date:** [If follow-up]

---

## Study Information

**Protocol Number:** [Protocol ID]  
**Protocol Title:** [Full study title]  
**Study Phase:** [ ] Phase I  [ ] Phase II  [ ] Phase III  [ ] Phase IV  
**Study Sponsor:** [Sponsor name]  
**IND/IDE Number:** [IND or IDE number if applicable]  
**ClinicalTrials.gov ID:** [NCT number]

**Principal Investigator:** [Name]  
**Site Number:** [Site ID]  
**Site Name:** [Institution name]

---

## Subject Information (De-identified)

**Subject ID / Randomization Number:** [ID only, no name]  
**Subject Initials:** [XX] (if permitted by regulatory authority)  
**Age:** [Years] OR **Date of Birth:** [Year only: YYYY]  
**Sex:** [ ] Male  [ ] Female  [ ] Other  
**Race:** [Category]  
**Ethnicity:** [Hispanic or Latino / Not Hispanic or Latino]  
**Weight:** [kg]  
**Height:** [cm]

**Study Arm / Treatment Group:** [ ] Treatment A  [ ] Treatment B  [ ] Placebo  [ ] Blinded

**Date of Informed Consent:** [MM/DD/YYYY]  
**Date of First Study Drug:** [MM/DD/YYYY]  
**Date of Last Study Drug:** [MM/DD/YYYY]  
**Study Drug Status at Time of Event:** [ ] Ongoing  [ ] Completed  [ ] Discontinued

---

## Adverse Event Information

**Reported Term (Verbatim):** [Exact term reported by investigator/patient]

**MedDRA Coding:**
- **Preferred Term (PT):** [MedDRA PT]
- **System Organ Class (SOC):** [MedDRA SOC]
- **MedDRA Version:** [e.g., 25.0]

**Event Description:**
[Detailed narrative description of the adverse event]

**Date of Onset:** [MM/DD/YYYY]  
**Time of Onset:** [HH:MM] (if known and relevant)  
**Date of Resolution:** [MM/DD/YYYY] OR [ ] Ongoing  
**Duration:** [Days/hours if resolved]

**Event Location:** [ ] Inpatient  [ ] Outpatient  [ ] Home  [ ] Other: ________

---

## Seriousness Criteria

**This event is considered serious because it resulted in or required:**

- [ ] **Death** - Date of death: [MM/DD/YYYY]
- [ ] **Life-threatening** - Immediate risk of death at time of event
- [ ] **Hospitalization (initial or prolonged)** - Dates: [MM/DD/YYYY to MM/DD/YYYY]
- [ ] **Persistent or significant disability/incapacity**
- [ ] **Congenital anomaly/birth defect**
- [ ] **Medically important event** - Explanation: _________________

**Hospitalization Details (if applicable):**
- Admission Date: [MM/DD/YYYY]
- Discharge Date: [MM/DD/YYYY] OR [ ] Still hospitalized
- Hospital Name: [Name and location]
- ICU Admission: [ ] Yes  [ ] No  
  - If yes, dates: [MM/DD/YYYY to MM/DD/YYYY]

---

## Severity Assessment

**Severity (Intensity):**
- [ ] **Mild** - Noticeable but does not interfere with daily activities
- [ ] **Moderate** - Interferes with daily activities but manageable
- [ ] **Severe** - Prevents usual daily activities, requires intervention

*Note: Severity is not the same as seriousness*

---

## Outcome

- [ ] **Recovered/Resolved** - Complete resolution, returned to baseline
- [ ] **Recovering/Resolving** - Improving but not yet fully resolved
- [ ] **Not Recovered/Not Resolved** - Ongoing without improvement
- [ ] **Recovered/Resolved with Sequelae** - Persistent effects remain
- [ ] **Fatal** - Event resulted in death
- [ ] **Unknown** - Unable to determine outcome

**Date of Final Outcome (if resolved):** [MM/DD/YYYY]

---

## Causality Assessment

**Relationship to Study Drug:**
- [ ] **Not Related** - Clearly due to other cause
- [ ] **Unlikely Related** - Doubtful connection to study drug
- [ ] **Possibly Related** - Could be related, but other causes possible
- [ ] **Probably Related** - More likely related to study drug than other causes
- [ ] **Definitely Related** - Certain relationship to study drug

**Relationship to Study Procedures:**
- [ ] Not Related  [ ] Unlikely  [ ] Possibly  [ ] Probably  [ ] Definitely

**Relationship to Underlying Disease:**
- [ ] Not Related  [ ] Unlikely  [ ] Possibly  [ ] Probably  [ ] Definitely

**Relationship to Concomitant Medications:**
- [ ] Not Related  [ ] Unlikely  [ ] Possibly  [ ] Probably  [ ] Definitely
- Suspected medication(s): _____________________

**Rationale for Causality Assessment:**
[Detailed explanation of causality determination, including temporal relationship, biological plausibility, dechallenge/rechallenge if applicable, alternative explanations]

---

## Expectedness

**Is this event expected based on the Investigator's Brochure or protocol?**
- [ ] **Expected** - Listed in IB/protocol with similar characteristics
- [ ] **Unexpected** - Not listed OR more severe than documented

**Reference:** [IB version and section, or protocol section]

---

## Action Taken with Study Drug

- [ ] **No change** - Study drug continued at same dose
- [ ] **Dose reduced** - New dose: ______ (from ______)
- [ ] **Dose increased** - New dose: ______ (from ______)
- [ ] **Drug interrupted** - Dates: [MM/DD to MM/DD]
  - [ ] Resumed  [ ] Not resumed
- [ ] **Drug permanently discontinued** - Date: [MM/DD/YYYY]
- [ ] **Not applicable** - Event occurred after study drug discontinued

**Dechallenge:** [ ] Positive (improved after stopping)  [ ] Negative  [ ] Not done

**Rechallenge:** [ ] Positive (recurred after restarting)  [ ] Negative  [ ] Not done

---

## Treatment and Interventions

**Treatments Given for This Event:**

1. **[Medication/Procedure]**
   - Dose/Details: _________________
   - Route: _________________
   - Start Date: [MM/DD/YYYY]
   - Stop Date: [MM/DD/YYYY] OR [ ] Ongoing
   - Response: [ ] Effective  [ ] Partially effective  [ ] Not effective

2. **[Additional treatments]**

**Hospitalization Interventions:**
- [ ] IV fluids
- [ ] Oxygen therapy
- [ ] Mechanical ventilation
- [ ] Surgical intervention - Procedure: ______________
- [ ] ICU care
- [ ] Other: ______________

---

## Relevant Medical History

**Pre-existing Conditions Relevant to This Event:**
[List conditions that may be related to the event]

**Concomitant Medications at Time of Event:**

| Medication | Indication | Dose/Frequency | Start Date | Stop Date |
|------------|-----------|----------------|------------|-----------|
| [Name] | [Indication] | [Dose] | [MM/DD/YYYY] | [MM/DD/YYYY or Ongoing] |

---

## Laboratory and Diagnostic Tests

**Relevant Laboratory Values:**

| Test | Result | Units | Reference Range | Date | Relation to Event |
|------|--------|-------|----------------|------|-------------------|
| [Test] | [Value] | [Units] | [Range] | [MM/DD] | [Before/During/After] |

**Imaging/Diagnostic Studies:**
- **[Study type] ([Date]):** [Key findings]

**ECG/Monitoring:**
[Results if relevant]

---

## Detailed Event Narrative

[Comprehensive chronological narrative of the event]

**Minimum elements to include:**
- Patient demographics and study participation timeline
- Relevant medical history
- Chronological description of event development
- Symptoms, signs, and clinical course
- Diagnostic workup and results
- Treatments administered and response
- Clinical outcome and current status
- Investigator's assessment of causality and reasoning

**Example Structure:**
```
A [age]-year-old [sex] with a history of [relevant medical conditions] enrolled in 
Study [protocol] on [date] and was randomized to [treatment arm]. The patient had 
been receiving [study drug] at [dose] for [duration] when, on [date], the patient 
developed [initial symptoms]. 

[Describe progression of symptoms, timeline, clinical findings...]

[Describe diagnostic workup performed and results...]

[Describe treatments given and patient response...]

[Describe outcome and current status...]

The investigator assessed this event as [causality] related to study drug because 
[reasoning]. Alternative explanations include [list alternative causes considered].
```

---

## Investigator Assessment

**Investigator's Comments:**
[Additional relevant information, clinical interpretation, conclusions]

**Does this event meet criteria for expedited reporting to regulatory authorities?**
- [ ] Yes - Fatal or life-threatening unexpected SAE
- [ ] Yes - Other unexpected SAE
- [ ] No - Expected event

---

## Follow-up Information Required

**Information Pending (if initial or follow-up report):**
- [ ] Final outcome
- [ ] Laboratory results
- [ ] Pathology report
- [ ] Imaging results
- [ ] Autopsy results (if death)
- [ ] Consultant reports
- [ ] Medical records
- [ ] Dechallenge/rechallenge information
- [ ] Other: ______________

**Expected Date for Follow-up Report:** [MM/DD/YYYY]

---

## Regulatory Reporting

**Sponsor Safety Assessment:**
[To be completed by sponsor]
- Expectedness: [ ] Expected  [ ] Unexpected
- Relationship: [ ] Related  [ ] Not related
- Reportable to FDA/EMA: [ ] Yes  [ ] No
- Timeline: [ ] 7-day  [ ] 15-day  [ ] Annual

**IRB Notification:**
- Reported to IRB: [ ] Yes  [ ] No  [ ] Not required
- Date reported: [MM/DD/YYYY]
- IRB determination: _______________

---

## Signatures

**Investigator Signature:**

**Name:** [Principal Investigator name]  
**Title:** [MD, credentials]  
**Signature:** ____________________  
**Date:** [MM/DD/YYYY]

**I certify that this report is accurate and complete to the best of my knowledge.**

---

**Sponsor Representative (if applicable):**

**Name:** [Name]  
**Title:** [Medical Monitor, Safety Officer]  
**Signature:** ____________________  
**Date:** [MM/DD/YYYY]

---

## Attachments

- [ ] Relevant laboratory reports
- [ ] Imaging reports
- [ ] Pathology reports
- [ ] Discharge summary
- [ ] Death certificate (if applicable)
- [ ] Autopsy report (if applicable)
- [ ] Consultant notes
- [ ] Other: ______________

---

## Distribution List

- [ ] Study Sponsor
- [ ] FDA (if applicable)
- [ ] IRB/IEC
- [ ] Data Safety Monitoring Board (if applicable)
- [ ] Site regulatory files

---

## Notes

**Regulatory Timeline Requirements:**
- **Fatal or life-threatening unexpected SAEs:** 7 days for preliminary report, 15 days for complete
- **Other serious unexpected events:** 15 days
- **IRB notification:** Per institutional policy (typically 5-10 days)

**Key Points:**
- Complete all sections accurately
- Provide detailed narrative
- Include temporal relationships
- Document all sources of information
- Follow up until event resolved
- Maintain patient confidentiality
- Use only de-identified information


