# History and Physical Examination (H&P) Template

**Patient Name:** [Last, First]  
**Medical Record Number:** [MRN]  
**Date of Birth:** [MM/DD/YYYY]  
**Age:** [years]  
**Sex:** [M/F]

**Date of Admission/Encounter:** [MM/DD/YYYY]  
**Time:** [HH:MM]  
**Location:** [Hospital floor, Clinic, ED]  
**Admitting Service:** [Medicine, Surgery, etc.]  
**Attending Physician:** [Name]

---

## Chief Complaint (CC)

"[Patient's stated reason for seeking care, in quotes]"

---

## History of Present Illness (HPI)

[Patient Name] is a [age]-year-old [sex] with a history of [relevant PMHx] who presents with [chief complaint].

[Use OPQRST format for symptoms, provide chronological narrative]

**Onset:** [When did symptoms start? Sudden vs gradual onset?]  
**Location:** [Where? Does it radiate?]  
**Duration:** [How long?]  
**Character:** [Quality - sharp, dull, pressure, etc.]  
**Aggravating factors:** [What makes it worse?]  
**Relieving factors:** [What makes it better?]  
**Timing:** [Constant or intermittent? Pattern?]  
**Severity:** [0-10 scale for pain, functional impact]  
**Associated symptoms:** [Other symptoms?]

**Prior evaluations and treatments:**  
**Why presenting now:**

---

## Past Medical History (PMH)

1. [Condition] - diagnosed [year], [current status]
2. [Condition] - diagnosed [year], [treatment]
3. [Additional conditions]

[ ] No known medical problems

---

## Past Surgical History (PSH)

1. [Procedure] ([year]) - [indication, complications if any]
2. [Procedure] ([year])

[ ] No prior surgeries

---

## Medications

| Medication | Dose | Route | Frequency | Indication |
|------------|------|-------|-----------|------------|
| [Drug name] | [mg] | [PO/IV/etc] | [BID/etc] | [Why prescribed] |

[ ] No current medications

---

## Allergies

| Allergen | Reaction |
|----------|----------|
| [Drug/Food/Environmental] | [Type of reaction] |

[ ] No known drug allergies (NKDA)

---

## Family History (FH)

- **Father:** [Age/deceased at age X], [medical conditions]
- **Mother:** [Age/deceased at age X], [medical conditions]
- **Siblings:** [Number], [relevant conditions]
- **Children:** [Number], [relevant conditions]

[Note hereditary conditions relevant to patient's presentation]

[ ] Non-contributory

---

## Social History (SH)

**Tobacco:** [Current/former/never], [pack-years if applicable]  
**Alcohol:** [Frequency and amount, CAGE questions if indicated]  
**Illicit drugs:** [Current/former/never, type, route]  
**Occupation:** [Current or former occupation]  
**Living situation:** [Lives alone/with family, housing type]  
**Marital status:** [Single/married/divorced/widowed]  
**Sexual history:** [If relevant]  
**Exercise:** [Type and frequency]  
**Diet:** [General diet description]  
**Functional status:** [ADL independence, baseline activity level]

---

## Review of Systems (ROS)

[Systematic review - check relevant systems]

**Constitutional:** [ ] Fever [ ] Chills [ ] Night sweats [ ] Weight loss [ ] Weight gain [ ] Fatigue  
**Eyes:** [ ] Vision changes [ ] Eye pain [ ] Discharge  
**ENT:** [ ] Hearing loss [ ] Tinnitus [ ] Sinus problems [ ] Sore throat  
**Cardiovascular:** [ ] Chest pain [ ] Palpitations [ ] Edema [ ] Orthopnea [ ] PND [ ] Claudication  
**Respiratory:** [ ] Dyspnea [ ] Cough [ ] Wheezing [ ] Hemoptysis  
**Gastrointestinal:** [ ] Nausea [ ] Vomiting [ ] Diarrhea [ ] Constipation [ ] Abdominal pain [ ] Melena [ ] Hematochezia  
**Genitourinary:** [ ] Dysuria [ ] Frequency [ ] Urgency [ ] Hematuria [ ] Incontinence  
**Musculoskeletal:** [ ] Joint pain [ ] Swelling [ ] Stiffness [ ] Back pain [ ] Weakness  
**Skin:** [ ] Rash [ ] Lesions [ ] Itching [ ] Changes in moles  
**Neurological:** [ ] Headache [ ] Dizziness [ ] Syncope [ ] Seizures [ ] Weakness [ ] Numbness [ ] Tingling  
**Psychiatric:** [ ] Depression [ ] Anxiety [ ] Sleep disturbance  
**Endocrine:** [ ] Heat/cold intolerance [ ] Polyuria [ ] Polydipsia [ ] Polyphagia  
**Hematologic/Lymphatic:** [ ] Easy bruising [ ] Bleeding [ ] Lymph node swelling  
**Allergic/Immunologic:** [ ] Seasonal allergies [ ] Frequent infections

**All other systems reviewed and negative** [ ]

---

## Physical Examination

**Vital Signs:**
- Temperature: _____ °F (oral/axillary/tympanic)
- Blood Pressure: _____/_____ mmHg ([right arm, sitting])
- Heart Rate: _____ bpm (regular/irregular)
- Respiratory Rate: _____ breaths/min
- Oxygen Saturation: _____% on [room air / O2 at ___ L/min]
- Height: _____ cm / inches
- Weight: _____ kg / lbs
- BMI: _____ kg/m²
- Pain Score: ___/10

**General:**  
[Overall appearance, apparent vs stated age, nutritional status, distress level]

**HEENT:**
- Head: [Normocephalic, atraumatic, scalp lesions]
- Eyes: [PERRLA, EOMI, conjunctiva, sclera, fundoscopy if done]
- Ears: [TMs, canals, hearing]
- Nose: [Nares, septum, discharge, sinus tenderness]
- Throat: [Oropharynx, tonsils, dentition, mucosa]

**Neck:**  
[Supple/stiff, lymphadenopathy, thyroid, JVP, carotid bruits]

**Cardiovascular:**
- Inspection: [PMI, precordial movement]
- Palpation: [PMI location, thrills, lifts]
- Auscultation: [Rate, rhythm, S1/S2, murmurs/rubs/gallops, location and radiation]
- Peripheral pulses: [Radial, femoral, DP, PT - rate quality bilaterally]
- Extremities: [Edema, cyanosis, clubbing]

**Pulmonary:**
- Inspection: [Respiratory effort, use of accessory muscles, chest wall deformities]
- Palpation: [Tactile fremitus, chest expansion]
- Percussion: [Resonance, dullness]
- Auscultation: [Breath sounds, adventitious sounds - location and quality]

**Abdomen:**
- Inspection: [Contour, scars, distention, visible peristalsis]
- Auscultation: [Bowel sounds - present, hyperactive, hypoactive, absent]
- Percussion: [Tympany, dullness, liver span, spleen]
- Palpation: [Soft/firm, tenderness, masses, organomegaly, rebound, guarding, Murphy's sign]

**Musculoskeletal:**
- Inspection: [Deformities, swelling, erythema]
- Palpation: [Tenderness, warmth]
- Range of motion: [Active and passive, limitations]
- Strength: [5-point scale by major muscle groups]
- Gait: [Normal, antalgic, ataxic, spastic]

**Skin:**  
[Color, temperature, moisture, turgor, lesions, rashes, wounds]

**Neurological:**
- Mental Status: [Alert, oriented x3 (person, place, time), speech, memory]
- Cranial Nerves: [II-XII - document abnormalities]
- Motor: [Strength 5-point scale, tone, bulk, fasciculations]
- Sensory: [Light touch, pinprick, proprioception, vibration]
- Reflexes: [Deep tendon reflexes 0-4+ scale, Babinski]
- Coordination: [Finger-to-nose, heel-to-shin, rapid alternating movements]
- Gait: [Already documented above or describe here]

**Psychiatric:**  
[Mood, affect, thought process, thought content, judgment, insight]

**Genitourinary:** (if applicable)  
[Defer/document findings if examined]

**Rectal:** (if applicable)  
[Defer/document findings if examined]

---

## Laboratory and Imaging Results

[Include relevant results available at time of H&P]

**Labs ([Date]):**

| Test | Result | Reference Range | Flag |
|------|--------|----------------|------|
| WBC | [Value] | [Range] | [H/L/-] |
| Hemoglobin | [Value] | [Range] | [H/L/-] |
| [Additional labs] | | | |

**Imaging ([Study], [Date]):**  
[Key findings]

**ECG ([Date]):**  
[Rate, rhythm, intervals, axis, ST-T changes, other findings]

**Other Studies:**

---

## Assessment and Plan

**Assessment:**

[Patient summary statement in one sentence]

**Problem List:**

**1. [Primary Problem/Diagnosis] ([ICD-10 code])**

**Assessment:** [Brief description of problem, severity, stability]

**Plan:**
- **Diagnostics:** [Labs, imaging, consultations needed]
- **Therapeutics:** [Medications, procedures, interventions]
  - [Medication]: [dose, route, frequency] for [indication]
- **Monitoring:** [What to monitor, how often]
- **Follow-up:** [When and with whom]
- **Disposition:** [Admit to floor/ICU, discharge, observation]

**2. [Secondary Problem] ([ICD-10 code])**

**Assessment:** [Description]

**Plan:**
- [Diagnostics]
- [Therapeutics]
- [Monitoring]

**3. [Additional Problems]**
[Continue for all active problems]

**Code Status:** [Full code / DNR / DNI / Other]

**Prophylaxis:**
- DVT prophylaxis: [Pharmacologic and/or mechanical]
- GI prophylaxis: [If indicated]
- Aspiration precautions: [If indicated]

**Disposition:** [Admit to service, location (floor/ICU), level of care]

---

## Signature

**Physician:** [Name, credentials]  
**Level:** [Intern, Resident, Attending]  
**Date/Time:** [MM/DD/YYYY at HH:MM]  
**Signature:** ____________________

**Co-signature (if applicable):**  
**Attending:** [Name, credentials]  
**Date/Time:** [MM/DD/YYYY at HH:MM]  
**Signature:** ____________________

---

## Template Completion Checklist

- [ ] Chief complaint documented
- [ ] HPI comprehensive (≥4 HPI elements for billing)
- [ ] PMH reviewed
- [ ] Medications reconciled
- [ ] Allergies documented
- [ ] ROS performed (≥10 systems for comprehensive)
- [ ] Complete physical exam documented (≥8 systems for comprehensive)
- [ ] Labs/imaging reviewed
- [ ] Assessment and plan for each problem
- [ ] Code status documented
- [ ] Prophylaxis addressed
- [ ] Disposition clear
- [ ] Completed within 24 hours of admission (TJC requirement)
- [ ] Signed and dated


