# Output Templates

## 1. Standard Learning Notes

```markdown
# [Article Title] - Learning Notes

**Author:** [Name] | **Source:** [URL/Publication] | **Date:** [When read]  
**Reading Time:** [X minutes] | **My Purpose:** [Why I read this]

---

## 🎯 One-Sentence Summary
[Capture the essence in one sentence]

---

## 📊 Structure at a Glance

**Main Thesis:** [Core argument]

**Supporting Pillars:**
1. [Main point 1]
2. [Main point 2]  
3. [Main point 3]

---

## 💡 Key Insights (Top 3)

### 1. [Insight Name]
**What:** [Description in my own words]  
**Why it matters:** [Significance]  
**How to use:** [Application]

### 2. [Insight Name]
**What:** [Description]
**Why it matters:** [Significance]
**How to use:** [Application]

### 3. [Insight Name]
**What:** [Description]
**Why it matters:** [Significance]
**How to use:** [Application]

---

## 🔍 Critical Analysis

### Strengths
- ✅ [What's well-argued]
- ✅ [Strong evidence]

### Weaknesses
- ⚠️ [Logical gap]
- ⚠️ [Weak support]

### Unanswered Questions
- ❓ [Question 1]
- ❓ [Question 2]

---

## 🔗 Connections

**Reminds me of:**
- [Other book/article/concept]
- [Personal experience]

**Contradicts:**
- [Opposing viewpoint I've encountered]

**Builds on:**
- [Prior knowledge this extends]

---

## 📝 Key Quotes & Context

> "[Quote 1]"

Why notable: [My interpretation]

> "[Quote 2]"

Why notable: [My interpretation]

---

## 🎯 Action Items

**Immediate (This Week):**
- [ ] [Specific action]
- [ ] [Specific action]

**Short-term (This Month):**
- [ ] [Specific action]

**Long-term:**
- [ ] [Specific action]

---

## 🔖 Further Exploration

**To Read:**
- [Related article/book]
- [Author's other work]

**To Discuss:**
- [Question for peers/mentor]

**To Test:**
- [Hypothesis to validate]

---

## 💭 Personal Reflection

[How has this changed my thinking?]
[What surprised me?]
[What will I do differently?]
```

---

## 2. Concept Map Template

```markdown
# Concept Map: [Topic]

## Core Concept
[Central idea in one box]

## Related Concepts

### Direct Connections
[Concept A] ←→ [Core] : [Relationship]
[Concept B] ←→ [Core] : [Relationship]

### Secondary Connections  
[Concept C] ←→ [Concept A] : [Relationship]

## Hierarchy
[Broader concept]
    ↓
[Core concept]
    ↓
├─ [Specific example 1]
├─ [Specific example 2]
└─ [Specific example 3]

## Cross-Domain Parallels
- In [Field A]: This is like [Analogy]
- In [Field B]: This is like [Analogy]
```

---

## 3. Argument Analysis Template

```markdown
# Argument Analysis: [Article Title]

## The Claim
**Main Thesis:** [What author argues]

## The Support

### Evidence Presented
1. [Evidence 1]
   - Type: [Data/Anecdote/Study/Expert opinion]
   - Strength: ⭐⭐⭐⭐⭐ (1-5)
   - Notes: [Assessment]

2. [Evidence 2]
   - Type: [Type]
   - Strength: ⭐⭐⭐
   - Notes: [Assessment]

### Logical Structure
[Premise 1] + [Premise 2] → [Conclusion]

**Valid?** [Yes/No/Partially]
**Sound?** [Yes/No - are premises true?]

## Counter-Arguments

### Acknowledged by Author
- [Counter-point mentioned]
- [Author's response]
- [My assessment of response]

### Not Addressed
- [Missing counter-argument 1]
- [Missing counter-argument 2]

## Alternative Explanations
The data could also mean:
- [Alternative 1]
- [Alternative 2]

## Verdict
**Overall Assessment:** [Rating + reasoning]
**When argument is strongest:** [Context]
**When argument is weakest:** [Context]
```

---

## 4. Practical Application Template

```markdown
# Application Plan: [Concept from Article]

## Current Situation
**Problem I'm facing:** [Specific issue]
**Why this concept is relevant:** [Connection]

## The Concept
[Brief explanation in my words]

## Application Strategy

### Phase 1: Test (Week 1)
**Experiment:** [Small, low-risk test]
**Measure:** [How I'll know if it works]
**Expected outcome:** [Hypothesis]

### Phase 2: Refine (Week 2-3)
**Based on test results:**
- If works: [How to expand]
- If doesn't work: [What to adjust]

### Phase 3: Integrate (Month 2)
**Full implementation:** [How to make it routine]

## Success Metrics
- **Leading indicator:** [Early signal]
- **Lagging indicator:** [Long-term outcome]

## Obstacles & Solutions
| Potential Obstacle | Mitigation Strategy |
|--------------------|---------------------|
| [Obstacle 1] | [How to handle] |
| [Obstacle 2] | [How to handle] |

## Check-in Schedule
- [ ] Day 7: [Review question]
- [ ] Day 30: [Review question]
- [ ] Day 90: [Review question]
```

---

## 5. Compare & Contrast Template

```markdown
# Comparison: [Source 1] vs [Source 2]

## On [Topic/Question]

### [Source 1] Position
**Core claim:** [What they argue]
**Key evidence:** [Main support]
**Assumptions:** [What they take as given]

### [Source 2] Position  
**Core claim:** [What they argue]
**Key evidence:** [Main support]
**Assumptions:** [What they take as given]

## Points of Agreement
1. [Overlap 1]
2. [Overlap 2]

## Points of Divergence
| Aspect | Source 1 | Source 2 |
|--------|----------|----------|
| [Dimension] | [View] | [View] |
| [Dimension] | [View] | [View] |

## Analysis
**Why they disagree:**
- Different values: [Explanation]
- Different data: [Explanation]  
- Different frames: [Explanation]

**Who's more convincing and why:**
[Assessment with reasoning]

**Synthesis:**
[Can we integrate both views? Middle ground?]
```

---

## 6. Quick Reference Card

```markdown
# Quick Ref: [Topic]

## The Concept
[2-3 sentence explanation]

## When to Use
- ✅ [Situation 1]
- ✅ [Situation 2]
- ❌ NOT for [Situation 3]

## Key Steps
1. [Step 1]
2. [Step 2]
3. [Step 3]

## Remember
💡 [Most important insight]
⚠️ [Common mistake to avoid]

## Example
[One concrete scenario showing application]
```

---

## 7. Feynman Technique Template

```markdown
# Teach [Concept]

## Explain Like I'm 5
[Simplest possible explanation, no jargon]

## Key Analogy
[Concept] is like [everyday thing] because [reasoning]

## The Steps (Simple)
1. [First, you...]
2. [Then, you...]
3. [Finally, you...]

## Common Confusion
**People often think:** [Misconception]
**But actually:** [Correction]
**Why the confusion:** [Reason]

## Test Questions
1. [Question to check understanding]
2. [Question to check understanding]

## Gaps I Found
While explaining, I realized I don't fully understand:
- [Gap 1]
- [Gap 2]

**Need to review:** [Specific sections/concepts]
```

---

## 8. Decision Matrix Template

```markdown
# Should I [Action Based on Reading]?

## Options
1. [Option A - fully implement]
2. [Option B - partially implement]
3. [Option C - don't implement]

## Evaluation Criteria

| Criterion | Weight | Option A | Option B | Option C |
|-----------|--------|----------|----------|----------|
| [Impact] | 40% | 8/10 | 5/10 | 1/10 |
| [Effort] | 30% | 3/10 | 7/10 | 10/10 |
| [Risk] | 20% | 6/10 | 8/10 | 10/10 |
| [Alignment] | 10% | 9/10 | 7/10 | 2/10 |
| **Total** | | **X.X** | **X.X** | **X.X** |

## Decision
[Chosen option] because [reasoning]

## Implementation Plan
[If proceeding, link to practical application template]
```

---

## Usage Guide

**For Different Goals:**

- **Just learning:** Use Template #1 (Standard Notes)
- **Deep understanding:** Use Template #2 (Concept Map) + #7 (Feynman)
- **Critical evaluation:** Use Template #3 (Argument Analysis)
- **Taking action:** Use Template #4 (Application Plan)
- **Comparing sources:** Use Template #5 (Compare & Contrast)
- **Quick reference:** Use Template #6 (Reference Card)
- **Making decisions:** Use Template #8 (Decision Matrix)

**Combine as needed:** Many analyses benefit from multiple templates.
