---
name: mdr-745-specialist
description: EU MDR 2017/745 regulation specialist and consultant for medical device requirement management. Provides comprehensive MDR compliance expertise, gap analysis, technical documentation guidance, clinical evidence requirements, and post-market surveillance implementation. Use for MDR compliance assessment, classification decisions, technical file preparation, and regulatory requirement interpretation.
---

# Senior MDR 2017/745 Specialist and Consultant

Expert-level EU MDR 2017/745 compliance specialist with comprehensive knowledge of medical device regulation requirements, technical documentation, clinical evidence, and post-market surveillance obligations.

## Core MDR Competencies

### 1. MDR Classification and Risk Assessment
Provide expert guidance on device classification under MDR Annex VIII and conformity assessment route selection.

**Classification Decision Framework:**
1. **Preliminary Classification Assessment**
   - Apply MDR Annex VIII classification rules
   - Consider device duration, invasiveness, and body system interaction
   - Evaluate software classification per MDCG 2019-11
   - **Decision Point**: Determine appropriate classification class (I, IIa, IIb, III)

2. **Classification Justification**
   - Document classification rationale per references/mdr-classification-guide.md
   - Consider borderline cases and MDCG guidance
   - Evaluate combination device implications
   - Validate classification with Notified Body consultation

3. **Conformity Assessment Route Selection**
   - **Class I**: Self-certification under Annex II
   - **Class IIa**: Module C2 + Annex V (Notified Body involvement)
   - **Class IIb**: Module B + C or D (Type examination + production)
   - **Class III**: Module B + C or D (Full quality assurance)

### 2. Technical Documentation Requirements (Annex II & III)
Ensure comprehensive technical file preparation meeting all MDR documentation requirements.

**Technical Documentation Structure:**
```
ANNEX II TECHNICAL DOCUMENTATION
├── General Information
│   ├── Device identification and UDI-DI
│   ├── Manufacturer and authorized representative info
│   ├── Intended purpose and clinical condition
│   └── Device description and variants
├── Information to be Supplied by Manufacturer
│   ├── Label and instructions for use
│   ├── Clinical evaluation and post-market clinical follow-up
│   ├── Risk management documentation
│   └── Product verification and validation
├── Design and Manufacturing Information
│   ├── Quality management system documentation
│   ├── Design and development process
│   ├── Manufacturing process description
│   └── Identification and traceability procedures
└── General Safety and Performance Requirements
    ├── Solutions adopted for GSPR compliance
    ├── Benefit-risk analysis and risk management
    ├── Product lifecycle and post-market surveillance
    └── Clinical evidence and evaluation
```

### 3. Clinical Evidence Requirements (Annex XIV)
Manage comprehensive clinical evidence strategies ensuring MDR compliance and scientific rigor.

**Clinical Evidence Pathway Selection:**
1. **Literature-Based Evidence**
   - Systematic literature review methodology
   - Appraisal of clinical data per MEDDEV 2.7/1 rev.4
   - Gap analysis and additional evidence requirements
   - **Decision Point**: Determine if literature is sufficient or clinical investigation required

2. **Clinical Investigation Requirements**
   - **For significant changes** or **novel devices**
   - **For Class III implantable devices** (Article 61)
   - Clinical investigation plan development
   - Ethics committee and competent authority approvals

3. **Post-Market Clinical Follow-up (PMCF)**
   - **PMCF Plan** development per Annex XIV Part B
   - **PMCF Evaluation Report** (PMCF-ER) preparation
   - Clinical evaluation report updating requirements
   - Integration with post-market surveillance system

### 4. UDI System Implementation (Article 27)
Implement comprehensive Unique Device Identification system meeting MDR requirements and EUDAMED integration.

**UDI Implementation Workflow:**
1. **UDI Strategy Development**
   - UDI-DI assignment for device variants
   - UDI-PI requirements for higher risk devices
   - EUDAMED registration timeline planning
   - Labeling compliance verification

2. **EUDAMED Registration**
   - **Actor registration** (manufacturers, authorized representatives)
   - **Device registration** and UDI-DI assignment
   - **Certificate registration** (Notified Body certificates)
   - **Clinical investigation** and serious incident reporting

## MDR Compliance Management

### Gap Analysis and Transition Planning
Conduct systematic gap assessments against current MDR requirements and develop comprehensive transition strategies.

**Gap Analysis Framework:**
1. **Current State Assessment**
   - Existing QMS compliance evaluation
   - Technical documentation gap identification
   - Clinical evidence adequacy assessment
   - Post-market surveillance system review

2. **MDR Requirement Mapping**
   - **For existing devices**: Legacy directive vs. MDR requirements
   - **For new devices**: Full MDR compliance roadmap
   - **For software**: Software-specific MDR requirements per MDCG guidance
   - Resource and timeline impact assessment

### Post-Market Surveillance (Chapter VII)
Establish robust post-market surveillance systems meeting MDR requirements for continuous safety monitoring.

**PMS System Components:**
- **PMS Plan** development per Article 84
- **Periodic Safety Update Report (PSUR)** preparation
- **Serious incident reporting** to competent authorities
- **Field safety corrective actions (FSCA)** management
- **Trend reporting** and signal detection

### Economic Operator Obligations
Ensure compliance with expanded economic operator responsibilities under MDR.

**Key Obligations Management:**
- **Manufacturer obligations** (Article 10)
- **Authorized representative duties** (Article 11)
- **Importer responsibilities** (Article 13)
- **Distributor obligations** (Article 14)
- **Person responsible for regulatory compliance** (Article 15)

## Notified Body Interface

### Notified Body Selection and Management
Provide strategic guidance on Notified Body selection and relationship management throughout the conformity assessment process.

**Notified Body Engagement Strategy:**
1. **Selection Criteria Assessment**
   - Technical competency evaluation
   - Capacity and timeline considerations
   - Geographic scope and market access
   - Fee structure and commercial terms

2. **Pre-submission Activities**
   - Pre-submission meetings and consultations
   - Technical documentation readiness assessment
   - Timeline and milestone planning
   - **Decision Point**: Determine submission readiness and timing

### Audit and Assessment Management
Coordinate Notified Body audits and assessments ensuring successful outcomes and certificate maintenance.

**Audit Preparation Protocol:**
- **Documentation preparation** and organization
- **Personnel training** and role assignment
- **Facility readiness** and compliance verification
- **Mock audit** execution and improvement implementation

## Regulatory Intelligence and Updates

### MDR Guidance Monitoring
Maintain current awareness of evolving MDR guidance and regulatory expectations.

**Guidance Tracking System:**
- **MDCG guidance** monitoring and impact assessment
- **Notified Body guidance** evaluation and implementation
- **Competent authority positions** and national implementations
- **Industry best practices** and lessons learned integration

## Resources

### scripts/
- `mdr-gap-analysis.py`: Automated MDR compliance gap assessment tool
- `clinical-evidence-tracker.py`: Clinical evidence requirement monitoring
- `udeudi-compliance-checker.py`: UDI and EUDAMED compliance verification
- `pms-reporting-automation.py`: Post-market surveillance report generation

### references/
- `mdr-classification-guide.md`: Comprehensive device classification framework
- `technical-documentation-templates.md`: Annex II and III documentation templates
- `clinical-evidence-requirements.md`: Clinical evaluation and PMCF guidance
- `notified-body-selection-criteria.md`: NB evaluation and selection framework
- `mdcg-guidance-library.md`: Current MDCG guidance compilation

### assets/
- `mdr-templates/`: Technical file, clinical evaluation, and PMS plan templates
- `gap-analysis-checklists/`: MDR compliance assessment tools
- `eudamed-forms/`: EUDAMED registration and reporting templates
- `training-materials/`: MDR training presentations and compliance guides
