# Official Links and Resources

Quick reference to official OpenAI Agents SDK documentation and resources.

---

## Official Documentation

### Main Documentation
- **Homepage**: https://openai.github.io/openai-agents-js/
- **Getting Started**: https://openai.github.io/openai-agents-js/getting-started
- **API Reference**: https://openai.github.io/openai-agents-js/api

### Guides
- **Quickstart**: https://openai.github.io/openai-agents-js/guides/quickstart
- **Agents**: https://openai.github.io/openai-agents-js/guides/agents
- **Handoffs**: https://openai.github.io/openai-agents-js/guides/handoffs
- **Tools**: https://openai.github.io/openai-agents-js/guides/tools
- **Guardrails**: https://openai.github.io/openai-agents-js/guides/guardrails
- **Human-in-the-Loop**: https://openai.github.io/openai-agents-js/guides/human-in-the-loop
- **Streaming**: https://openai.github.io/openai-agents-js/guides/streaming
- **Multi-Agent**: https://openai.github.io/openai-agents-js/guides/multi-agent
- **Voice Agents**: https://openai.github.io/openai-agents-js/guides/voice-agents
- **Results**: https://openai.github.io/openai-agents-js/guides/results
- **Running Agents**: https://openai.github.io/openai-agents-js/guides/running-agents

---

## GitHub Repository

### Main Repo
- **Source Code**: https://github.com/openai/openai-agents-js
- **Issues**: https://github.com/openai/openai-agents-js/issues
- **Releases**: https://github.com/openai/openai-agents-js/releases
- **Examples**: https://github.com/openai/openai-agents-js/tree/main/examples

### Related Repos
- **Python SDK**: https://github.com/openai/openai-agents-python
- **Go SDK**: https://github.com/nlpodyssey/openai-agents-go
- **Realtime Examples**: https://github.com/openai/openai-realtime-agents

---

## npm Packages

### Core Packages
- **@openai/agents**: https://www.npmjs.com/package/@openai/agents
- **@openai/agents-realtime**: https://www.npmjs.com/package/@openai/agents-realtime

### Installation
```bash
npm install @openai/agents zod@3
npm install @openai/agents-realtime  # For voice agents
```

---

## OpenAI Platform

### API Documentation
- **API Overview**: https://platform.openai.com/docs/overview
- **Authentication**: https://platform.openai.com/docs/api-reference/authentication
- **Models**: https://platform.openai.com/docs/models
- **Realtime API**: https://platform.openai.com/docs/guides/realtime

### Pricing
- **Pricing Page**: https://openai.com/api/pricing/
- **GPT-4o**: $2.50 / 1M input tokens, $10.00 / 1M output tokens
- **GPT-4o-mini**: $0.15 / 1M input tokens, $0.60 / 1M output tokens

### Account
- **API Keys**: https://platform.openai.com/api-keys
- **Usage Dashboard**: https://platform.openai.com/usage
- **Playground**: https://platform.openai.com/playground

---

## Community

### Forums
- **OpenAI Community**: https://community.openai.com/
- **Developer Forum**: https://community.openai.com/c/api/7
- **Agents Discussion**: Search "agents sdk" on community

### Social
- **OpenAI Twitter**: https://twitter.com/OpenAI
- **OpenAI Blog**: https://openai.com/blog/

---

## Engineering Blog

### Key Articles
- **Agents SDK Announcement**: Check OpenAI blog for official announcement
- **Swarm to Agents Migration**: (Agents SDK is successor to experimental Swarm)

---

## Related Tools

### Development Tools
- **Zod**: https://zod.dev/ (Schema validation)
- **TypeScript**: https://www.typescriptlang.org/
- **Vercel AI SDK**: https://ai-sdk.dev/ (For multi-provider support)

### Frameworks
- **Next.js**: https://nextjs.org/
- **Hono**: https://hono.dev/
- **Cloudflare Workers**: https://developers.cloudflare.com/workers/

---

## Examples and Templates

### Official Examples
- **Basic Examples**: https://github.com/openai/openai-agents-js/tree/main/examples
- **Voice Examples**: https://github.com/openai/openai-agents-js/tree/main/examples/realtime
- **Multi-Agent Examples**: https://github.com/openai/openai-agents-js/tree/main/examples/agent-patterns

### Community Examples
- Check GitHub for "openai-agents-js" topic: https://github.com/topics/openai-agents

---

## Support

### Getting Help
1. **Documentation**: Start with official docs
2. **GitHub Issues**: Search existing issues first
3. **Community Forum**: Ask in OpenAI Community
4. **Stack Overflow**: Tag with `openai-agents-js`

### Reporting Bugs
- **GitHub Issues**: https://github.com/openai/openai-agents-js/issues/new
- Include: SDK version, code snippet, error message, environment

---

## Version Information

### Current Versions (as of 2025-10-26)
- **@openai/agents**: 0.2.1
- **@openai/agents-realtime**: 0.2.1
- **Required zod**: ^3.x

### Version History
- Check releases: https://github.com/openai/openai-agents-js/releases

### Migration Guides
- Check docs for breaking changes between versions
- Always test after upgrading

---

## Comparison with Other Frameworks

### vs Swarm
- **Swarm**: Experimental project (deprecated)
- **Agents SDK**: Production-ready successor

### vs LangChain
- **LangChain**: Framework-agnostic, many providers
- **Agents SDK**: OpenAI-focused, simpler API

### vs OpenAI Assistants API
- **Assistants API**: Managed state, threads, files
- **Agents SDK**: Full control, custom orchestration

---

## Changelog

### v0.2.1 (2025-10)
- Realtime voice agent improvements
- Bug fixes for MCP integration
- Performance optimizations

### v0.1.x
- Initial public release
- Core agent features
- Handoffs and tools

---

**Last Updated**: 2025-10-26
**SDK Version**: 0.2.1

**Note**: Links verified current. Check official sources for latest updates.
