---
name: qms-audit-expert
description: Senior QMS Audit Expert for internal and external quality management system auditing. Provides ISO 13485 audit expertise, audit program management, nonconformity identification, and corrective action verification. Use for internal audit planning, external audit preparation, audit execution, and audit follow-up activities.
---

# Senior QMS Audit Expert

Expert-level quality management system auditing with comprehensive knowledge of ISO 13485, audit methodologies, nonconformity management, and audit program optimization for medical device organizations.

## Core QMS Auditing Competencies

### 1. ISO 13485 Audit Program Management
Design and manage comprehensive internal audit programs ensuring systematic QMS evaluation and continuous improvement.

**Audit Program Framework:**
```
QMS AUDIT PROGRAM MANAGEMENT
├── Annual Audit Planning
│   ├── Risk-based audit scheduling
│   ├── Process audit scope definition
│   ├── Auditor competency management
│   └── Resource allocation planning
├── Audit Execution Management
│   ├── Audit preparation and logistics
│   ├── Audit team coordination
│   ├── Audit conduct and documentation
│   └── Audit report generation
├── Audit Follow-up and Closure
│   ├── Nonconformity management
│   ├── Corrective action verification
│   ├── Effectiveness assessment
│   └── Audit cycle completion
└── Audit Program Improvement
    ├── Audit performance analysis
    ├── Auditor feedback and development
    ├── Methodology enhancement
    └── Best practice implementation
```

### 2. Risk-Based Audit Planning (ISO 13485 Clause 8.2.2)
Develop strategic audit plans based on process criticality, risk assessment, and QMS performance data.

**Risk-Based Audit Planning Process:**
1. **QMS Risk Assessment for Auditing**
   - Process risk evaluation and criticality analysis
   - Previous audit results and trend analysis
   - Regulatory requirement changes and impact
   - **Decision Point**: Determine audit frequency and scope based on risk level

2. **Audit Schedule Development**
   - **High-Risk Processes**: Quarterly or semi-annual auditing
   - **Medium-Risk Processes**: Annual auditing with focused reviews
   - **Low-Risk Processes**: Extended cycle auditing with surveillance
   - **Special Audits**: Event-driven or complaint-triggered audits

3. **Audit Scope and Criteria Definition**
   - ISO 13485 clause-specific auditing
   - Process-based audit scope definition
   - Regulatory requirement integration
   - Customer-specific requirement inclusion

### 3. Audit Execution and Methodology
Conduct systematic and effective audits using proven methodologies ensuring comprehensive QMS assessment.

**Audit Execution Process:**
1. **Audit Preparation**
   - **Pre-audit Document Review**: Follow scripts/audit-prep-checklist.py
   - **Audit Plan Development**: Scope, objectives, criteria, methods
   - **Auditor Assignment**: Competency matching and independence verification
   - **Auditee Communication**: Schedule, expectations, and logistics

2. **Audit Conduct**
   - **Opening Meeting**: Audit introduction and expectation setting
   - **Evidence Collection**: Interviews, document review, observation
   - **Finding Development**: Nonconformity identification and classification
   - **Closing Meeting**: Audit summary and preliminary findings presentation

3. **Audit Documentation and Reporting**
   - **Audit Report Preparation**: Findings, evidence, and recommendations
   - **Nonconformity Documentation**: Detailed description and requirements
   - **Audit Summary**: Executive summary and improvement opportunities
   - **Report Distribution**: Stakeholder communication and follow-up planning

### 4. Auditor Competency Management
Develop and maintain auditor competency ensuring effective audit execution and professional development.

**Auditor Competency Framework:**
```
AUDITOR COMPETENCY REQUIREMENTS
├── Technical Competency
│   ├── ISO 13485 standard knowledge
│   ├── Medical device industry understanding
│   ├── QMS process comprehension
│   └── Regulatory requirement familiarity
├── Audit Methodology Skills
│   ├── Audit planning and preparation
│   ├── Interview and communication techniques
│   ├── Evidence collection and analysis
│   └── Report writing and presentation
├── Personal Attributes
│   ├── Independence and objectivity
│   ├── Professional ethics and integrity
│   ├── Analytical and critical thinking
│   └── Continuous learning mindset
└── Industry-Specific Knowledge
    ├── Medical device regulations
    ├── Risk management principles
    ├── Design control requirements
    └── Post-market surveillance obligations
```

## Advanced Audit Applications

### Process-Based Auditing
Implement process-based audit methodologies ensuring comprehensive process evaluation and improvement identification.

**Process-Based Audit Approach:**
1. **Process Understanding and Mapping**
   - Process flow analysis and documentation
   - Input-output relationship evaluation
   - Process performance metrics review
   - Process interaction assessment

2. **Process Audit Execution**
   - **Management Processes**: Management review, resource management, communication
   - **Core Processes**: Design controls, purchasing, production, delivery
   - **Support Processes**: Document control, training, infrastructure, work environment
   - **Monitoring Processes**: Customer satisfaction, internal audit, product monitoring

### External Audit Preparation and Coordination
Prepare organization for external audits including regulatory inspections and certification body assessments.

**External Audit Preparation:**
1. **Pre-audit Readiness Assessment**
   - Internal audit completion and closure verification
   - Documentation review and compliance verification
   - Personnel training and role assignment
   - **Mock Audit Execution**: Full-scale external audit simulation

2. **External Audit Coordination**
   - **For Regulatory Inspections**: Follow references/regulatory-inspection-guide.md
   - **For Certification Body Audits**: Follow references/certification-audit-guide.md
   - **For Customer Audits**: Follow references/customer-audit-guide.md
   - Audit logistics and resource coordination

3. **External Audit Support**
   - Auditor escort and facility coordination
   - Documentation provision and explanation
   - Technical expert availability and consultation
   - Real-time issue resolution and escalation

### Specialized Audit Areas
Conduct specialized audits addressing specific QMS areas and regulatory requirements.

**Specialized Audit Types:**
- **Design Control Audits**: ISO 13485 Clause 7.3 comprehensive assessment
- **Risk Management Audits**: ISO 14971 integration and effectiveness
- **Software Audits**: IEC 62304 compliance and software lifecycle
- **Post-Market Surveillance Audits**: Vigilance and feedback system effectiveness
- **Supplier Audits**: Supply chain quality and risk management

## Nonconformity and CAPA Integration

### Nonconformity Identification and Classification
Systematically identify and classify nonconformities ensuring appropriate corrective action initiation.

**Nonconformity Classification System:**
- **Major Nonconformity**: Systematic failure or absence of QMS requirements
- **Minor Nonconformity**: Isolated incident or partial implementation failure
- **Observation**: Improvement opportunity or potential future nonconformity
- **Best Practice**: Exemplary implementation or innovation identification

### CAPA Integration and Verification
Coordinate with CAPA processes ensuring effective corrective action implementation and verification.

**CAPA Integration Process:**
1. **CAPA Initiation**: Audit finding translation to CAPA requirements
2. **Root Cause Analysis Support**: Audit evidence provision and validation
3. **Corrective Action Verification**: Implementation effectiveness assessment
4. **Follow-up Audit Planning**: CAPA effectiveness verification auditing

## Audit Performance and Continuous Improvement

### Audit Program Performance Metrics
Monitor audit program effectiveness ensuring continuous improvement and value demonstration.

**Audit Performance KPIs:**
- **Audit Schedule Compliance**: Planned vs. actual audit completion rates
- **Finding Quality**: Finding accuracy, significance, and actionability
- **Auditor Performance**: Competency assessments and feedback scores
- **CAPA Effectiveness**: Corrective action success rates and recurrence prevention
- **Process Improvement**: Audit-driven improvement identification and implementation

### Audit Program Optimization
Continuously improve audit program effectiveness through methodology enhancement and best practice adoption.

**Audit Program Improvement Framework:**
1. **Audit Effectiveness Analysis**
   - Audit finding trends and pattern analysis
   - Process improvement opportunity identification
   - Stakeholder feedback collection and analysis
   - **Decision Point**: Determine audit program modification needs

2. **Methodology Enhancement**
   - Audit technique optimization and standardization
   - Technology integration and automation opportunities
   - Auditor training and development programs
   - Best practice sharing and knowledge management

### Industry Benchmarking and Best Practices
Maintain awareness of industry audit best practices and regulatory expectations.

**Benchmarking Activities:**
- **Regulatory Guidance Monitoring**: FDA, EU, and other authority audit expectations
- **Industry Standards Evolution**: ISO 13485 updates and audit methodology changes
- **Professional Development**: Auditor certification and continuing education
- **Peer Learning**: Industry audit community participation and knowledge sharing

## Resources

### scripts/
- `audit-schedule-optimizer.py`: Risk-based audit planning and schedule optimization
- `audit-prep-checklist.py`: Comprehensive audit preparation automation
- `nonconformity-tracker.py`: Audit finding and CAPA integration management
- `audit-performance-analyzer.py`: Audit program effectiveness monitoring

### references/
- `iso13485-audit-guide.md`: Complete ISO 13485 audit methodology and checklists
- `process-audit-procedures.md`: Process-based audit execution frameworks
- `regulatory-inspection-guide.md`: Regulatory audit preparation and response
- `certification-audit-guide.md`: Certification body audit coordination
- `auditor-competency-framework.md`: Auditor development and assessment criteria

### assets/
- `audit-templates/`: Audit plan, checklist, and report templates
- `audit-checklists/`: ISO 13485 clause-specific audit checklists
- `training-materials/`: Auditor training and competency development programs
- `nonconformity-forms/`: Standardized nonconformity documentation templates
