# NSF (National Science Foundation) Grant Writing Guidelines

## Agency Overview

**Mission**: To promote the progress of science; to advance the national health, prosperity, and welfare; to secure the national defense

**Annual Budget**: ~$9-10 billion

**Website**: https://www.nsf.gov

**Key Characteristics**:
- Supports all fields of fundamental science and engineering (except medical sciences)
- Emphasis on education and workforce development
- Strong commitment to diversity, equity, and inclusion
- Promotes open science and data sharing
- Collaborative research across institutions encouraged

## NSF Directorates

1. **BIO** - Biological Sciences
2. **CISE** - Computer and Information Science and Engineering
3. **EHR** - Education and Human Resources
4. **ENG** - Engineering
5. **GEO** - Geosciences
6. **MPS** - Mathematical and Physical Sciences
7. **SBE** - Social, Behavioral, and Economic Sciences
8. **TIP** - Technology, Innovation, and Partnerships (formerly EDA)
9. **OPP** - Office of Polar Programs
10. **OISE** - Office of International Science and Engineering

## Core Review Criteria

NSF uses two equally weighted criteria for all proposals:

### Intellectual Merit

**Definition**: The potential to advance knowledge

**Evaluation Questions**:
- How important is the proposed activity to advancing knowledge and understanding within its own field or across different fields?
- How well-qualified is the proposer (individual or team) to conduct the project?
- To what extent does the proposed activity suggest and explore creative, original, or potentially transformative concepts?
- How well-conceived and organized is the proposed activity?
- Is there sufficient access to resources?

**Writing Strategy**:
- Lead with the research question and its importance
- Demonstrate deep knowledge of the field
- Articulate the knowledge gap clearly
- Present innovative approach to address the gap
- Show preliminary results or proof-of-concept
- Demonstrate team qualifications
- Present feasible, well-organized plan

### Broader Impacts

**Definition**: The potential to benefit society and contribute to the achievement of specific, desired societal outcomes

**Evaluation Questions**:
- What is the potential for the proposed activity to:
  - Benefit society or advance desired societal outcomes?
  - Broaden participation of underrepresented groups?
  - Enhance infrastructure for research and education?
  - Enhance scientific and technological understanding?
  - Foster partnerships between academia, industry, and others?

**Critical Point**: Broader Impacts are NOT an afterthought. They carry equal weight with Intellectual Merit and must be substantive, specific, and measurable.

**Five Pillars of Broader Impacts** (address at least one substantively):

1. **Advance discovery and understanding while promoting teaching, training, and learning**
   - Integrate research into courses
   - Develop new curriculum materials
   - Train undergraduate, graduate, and postdoctoral researchers
   - Provide research experiences for students
   - Create educational resources (videos, software, databases)
   - Offer workshops or training programs

   *Example*: "We will develop a 10-module online course on computational genomics, incorporating data from this project, to be offered to 500+ students annually across 15 partner institutions. Course materials will be open-access and include Jupyter notebooks for hands-on analysis."

2. **Broaden participation of underrepresented groups (in STEM)**
   - Partner with minority-serving institutions (HBCUs, HSIs, TCUs)
   - Recruit students from underrepresented groups
   - Provide mentoring and support programs
   - Address systemic barriers to participation
   - Create inclusive research environments
   - Engage underrepresented communities in research

   *Example*: "We will establish a summer research program for 8 undergraduates annually from 4 partner HBCUs, providing stipends, housing, and year-round mentoring. Program will include professional development workshops and pathways to graduate school."

3. **Enhance infrastructure for research and education**
   - Develop shared instrumentation or facilities
   - Create cyberinfrastructure, software, or databases
   - Build collaborative networks
   - Establish living stock centers or repositories
   - Develop standards or protocols
   - Create open-source tools

   *Example*: "We will develop and maintain an open-source software platform for analyzing spatial transcriptomics data, with comprehensive documentation, tutorials, and user support forum. Software will be deposited on GitHub and indexed in bio.tools."

4. **Disseminate to enhance scientific and technological understanding**
   - Public outreach and science communication
   - Engagement with K-12 students and teachers
   - Museum exhibits or science festivals
   - Media engagement (podcasts, videos, articles)
   - Policy briefs for decision-makers
   - Community science projects

   *Example*: "We will partner with the City Science Museum to create a hands-on exhibit on AI and climate modeling, reaching 50,000+ annual visitors. Exhibit will include interactive simulations and bilingual materials. We will also host quarterly 'Science Saturdays' for local K-12 students."

5. **Benefit society**
   - Economic development and competitiveness
   - Health and quality of life improvements
   - Environmental sustainability
   - National security
   - Societal well-being
   - Workforce development

   *Example*: "Our drought prediction models will be integrated into USDA's decision support system, benefiting 15,000+ farmers in the Southwest. We will work with extension agents to provide training and accessible interfaces for non-technical users."

**Common Broader Impacts Mistakes**:
- ❌ Vague statements: "We will train graduate students" (everyone does this)
- ❌ No plan: Aspirational goals without concrete activities
- ❌ No metrics: No way to assess success
- ❌ Tacked on: Not integrated with research plan
- ❌ Unrealistic: Grand claims without resources or expertise
- ✅ Specific and measurable: Clear activities, timelines, and assessment

## Proposal Sections and Page Limits

### Project Summary (1 page)

**Required Structure** (NSF mandates three labeled sections):

**Overview** (first paragraph):
- Research question and approach in accessible language
- Suitable for public dissemination

**Intellectual Merit**:
- Potential to advance knowledge
- Innovative aspects
- Qualifications of team

**Broader Impacts**:
- Societal benefits and specific activities
- How success will be measured

**Formatting**: Must use section headings exactly as shown above

### Project Description (15 pages for most programs)

**No required structure, but typical organization**:

1. **Introduction / Background** (1-2 pages)
   - Research question and significance
   - Current state of knowledge
   - Knowledge gaps
   - Preliminary results (if applicable)

2. **Research Objectives** (0.5-1 page)
   - Specific, measurable goals
   - Hypotheses or research questions

3. **Research Plan / Methodology** (8-10 pages)
   - Detailed approach for each objective
   - Methods and techniques
   - Timeline and milestones
   - Expected outcomes
   - Potential challenges and alternatives

4. **Broader Impacts** (1-2 pages)
   - Can be integrated throughout OR separate section
   - Specific activities and timelines
   - Assessment and evaluation plan

5. **Results from Prior NSF Support** (if applicable, up to 5 pages)
   - Required if PI or co-PI has had NSF award in past 5 years
   - Intellectual merit of prior work
   - Broader impacts of prior work
   - Publications and products

**Formatting Requirements**:
- Font: 11-point or larger (Times Roman, Arial, Palatino, Computer Modern)
- Margins: 1 inch all sides
- Line spacing: No more than 6 lines per inch
- Page size: 8.5 x 11 inches
- No smaller fonts in figures (must be legible)

### References Cited (no page limit)

- Each reference must include:
  - Names of all authors
  - Article and journal title
  - Volume, page numbers, year
  - DOI if available
- Use consistent format (doesn't have to match specific style)
- Sufficient information for reviewers to locate references

### Biographical Sketch (3 pages max per person)

**Required NSF Format** (as of 2023 PAPPG):

**Section A: Professional Preparation**
- Undergraduate, graduate, postdoctoral institutions
- Majors and degrees with years

**Section B: Appointments and Positions**
- Last 5 positions, current first

**Section C: Products** (up to 5 most relevant to proposal)
- Publications, datasets, software, patents, etc.
- Can include products in preparation

**Section D: Synergistic Activities** (up to 5)
- Service, teaching, mentoring, outreach
- Demonstrates broader engagement beyond research

### Current and Pending Support (no page limit)

- All current and pending support for PI and co-PIs
- Include project/proposal title, source, award amount, dates
- Describe overlap with proposed project (if any)
- Must be updated until award/decline

### Facilities, Equipment, and Other Resources (no page limit)

- Describe available facilities (labs, computational, libraries)
- Major equipment accessible to project
- Other resources (personnel, core facilities, partnerships)
- Demonstrate institutional commitment

### Data Management and Sharing Plan (2 pages max)

**Required for all proposals** (as of 2023 PAPPG)

**Must address**:
1. **Types of data**: What data will be generated?
2. **Standards**: Formats, metadata, standards for data and metadata
3. **Access**: How and when will data be shared?
4. **Reuse**: Who can access and under what conditions?
5. **Repository**: Where will data be archived long-term?
6. **Protection**: Privacy, confidentiality, intellectual property considerations

**NSF Expectations**:
- Data should be made publicly available in a timely manner
- Use discipline-specific repositories when available
- Justify any restrictions on data sharing
- Plan for data preservation beyond project period

### Postdoctoral Researcher Mentoring Plan (1 page max)

**Required if funding postdocs**

**Must address**:
- Career development objectives
- Mentoring activities (research, teaching, professional skills)
- Metrics for success
- Mentoring plan should be specific, not generic

## Special NSF Proposal Types

### CAREER (Faculty Early Career Development Program)

**Eligibility**: Tenure-track (or equivalent) faculty who have not yet received tenure, within 6 years of PhD (or equivalent)

**Requirements**:
- Integration of research and education
- Demonstrate potential for leadership
- Department chair letter required
- 5-year project plan
- Typical budget: $400,000-$500,000

**Key Elements**:
- Ambitious research plan
- Innovative educational component
- Strong integration (not just parallel tracks)
- Path to independence and leadership
- Institutional commitment

**Review Criteria**: Same two criteria (Intellectual Merit, Broader Impacts) but with emphasis on:
- Integration of research and education
- Innovative educational component
- Potential for leadership in field

**Common CAREER Mistakes**:
- Education component feels tacked on
- Overly ambitious research plan
- Weak integration between research and education
- Generic mentoring or teaching plans
- Insufficient preliminary data

### Collaborative Research

**Structure**: Multiple proposals submitted separately from different institutions, reviewed as a single project

**Requirements**:
- Lead institution designated
- All proposals must have identical titles (except institution name)
- Project descriptions should be substantially similar
- Clear division of labor
- Coordination plan

**Budget**: Each institution submits own budget for their portion

**Review**: Reviewed together as single integrated project

**Benefits**: Brings together complementary expertise and resources

### RAPID (Rapid Response Research)

**Purpose**: Support time-sensitive research opportunities

**Examples**: 
- Natural disasters
- Disease outbreaks
- Unique astronomical events
- Rare opportunities for data collection

**Requirements**:
- Urgent need justification
- Up to $200,000
- Up to 1 year duration
- Simplified review process (program officer discretion)
- No preliminary data required

**Submission**: Contact program officer first, then submit proposal

### EAGER (Early-concept Grants for Exploratory Research)

**Purpose**: Support exploratory work on untested, but potentially transformative, ideas

**Requirements**:
- High-risk, high-reward research
- Radically different approaches
- Up to $300,000
- Up to 2 years
- Program officer approval required before submission
- No panel review (program officer decision)

**Key**: Must be truly exploratory and high-risk, not incremental

## Budget Considerations

### Allowable Costs

**Personnel**:
- Senior personnel: Up to 2 months (summer salary) for 9-month faculty
- Postdoctoral scholars: Full salary and benefits
- Graduate students: Stipend (tuition typically covered under fringe/indirect)
- Undergraduate students: Hourly or stipend
- Technical and administrative staff

**Fringe Benefits**: Follow institutional rates

**Equipment**: Items ≥$5,000 per unit
- Must be justified
- Shared equipment requires letters from collaborators

**Travel**:
- Domestic and international scientific meetings
- Collaboration and fieldwork
- Justification required

**Participant Support Costs**: For workshops, training, conferences
- Stipends, travel, subsistence for participants
- Not subject to indirect costs

**Other Direct Costs**:
- Publication costs
- Consulting services
- Computer services
- Materials and supplies
- Subawards to collaborating institutions

**Indirect Costs (F&A)**: Institutional negotiated rate applies to modified total direct costs (MTDC)
- MTDC excludes: equipment, participant support, subawards >$25K

### Cost Sharing

**NSF Policy**: Cost sharing is not required and should not be voluntary

**Exceptions**: Some programs require cost sharing (check program solicitation)

**When Included**: Must be documented, verifiable, auditable, and necessary for project

## Submission and Review Process

### Submission Deadlines

**Varies by program**:
- Some programs have specific deadlines (e.g., twice per year)
- Some programs accept proposals anytime (check with program officer)
- CAREER: July deadline (directorate-specific)

**Submission Windows**: NSF deadlines are typically 5 PM submitter's local time

### Submission Portal

**Research.gov** or **Grants.gov**: NSF accepts both

**Process**:
1. Institutional authorization required
2. Upload all required documents
3. Verify PDF compilation
4. Submit (aim for 48 hours early)
5. Receive confirmation and proposal number

### Review Process

**Timeline**: Typically 6 months from submission to decision

**Steps**:
1. **Administrative Review**: NSF checks compliance (1-2 weeks)
2. **Program Officer Assignment**: Assigned to appropriate program (1-2 weeks)
3. **Reviewer Selection**: Panel and/or ad hoc reviewers identified (2-4 weeks)
4. **Review**: Reviewers assess proposals (4-8 weeks)
5. **Panel Discussion**: Panel meets (virtual or in-person) to discuss proposals (1 week)
6. **Program Officer Recommendation**: Based on reviews and panel discussion (2-4 weeks)
7. **Division/Directorate Approval**: Final decision (2-4 weeks)

**Review Formats**:
- **Panel Review**: 10-20 proposals discussed at panel meeting
- **Ad hoc Review**: External reviewers submit written reviews
- **Hybrid**: Combination of panel and ad hoc reviews

**Number of Reviewers**: Typically 3-5 reviewers per proposal

### Review Outcomes

**Possible Decisions**:
- **Funded**: Congratulations! Award forthcoming
- **Declined**: Not recommended for funding
- **Returned Without Review**: Non-compliant with requirements

**Feedback**: Panel summary and individual reviews provided regardless of outcome

**Success Rates**: Vary by program, typically 15-30%

## Communicating with Program Officers

### When to Contact

**Appropriate**:
- Before submission: Discuss fit with program, feasibility of idea
- After reviews: Discuss feedback, resubmission strategy
- During project: Report significant changes, request no-cost extensions

**How to Contact**:
- Email program officer (contact info in program solicitation)
- Request 15-30 minute phone call
- Prepare concise summary of research idea (1 page)

### What to Ask

**Good Questions**:
- Is my research appropriate for this program?
- Are there upcoming solicitations or special initiatives?
- What are key areas of emphasis for the program?
- Is the scope and budget appropriate?
- After reviews: What are key issues to address in resubmission?

**Avoid**:
- Asking for guarantee of funding
- Arguing with review outcome
- Inappropriate requests for information about reviewers

## Resubmission Strategy

### NSF Resubmission Policies

**No Formal Resubmission Category**: NSF treats resubmissions as new proposals

**Can Resubmit**:
- To same program (after addressing reviews)
- To different program (if better fit)
- After substantial revision

**No Introduction Section**: Unlike NIH, NSF doesn't have formal resubmission response

**Strategy**:
- Carefully review panel summary and individual reviews
- Address all major criticisms
- Strengthen weak areas (prelim data, broader impacts, methods)
- Consider discussing with program officer
- May want to wait for next funding cycle to gather more data

**Tracking**: Proposals reviewed previously may be assigned same reviewers (sometimes)

## Recent NSF Policy Updates

### 2023-2024 Changes

1. **Data Management and Sharing Plan**: Now required for all proposals (2 pages max)
2. **Biographical Sketch Format**: Updated to include "Products" instead of "Publications"
3. **Open Science**: Increased emphasis on open-access publications and data
4. **Plan for Dissemination**: Some programs require explicit dissemination plans
5. **Mentoring Plans**: Enhanced requirements for postdoc mentoring plans

### NSF Priorities (2024-2025)

- **Climate and Clean Energy**: Climate change mitigation and adaptation
- **Quantum Information Science**: Quantum computing, sensing, networking
- **AI and Machine Learning**: Trustworthy AI, AI for science
- **Biotechnology**: Synthetic biology, bioengineering
- **Microelectronics**: Semiconductor research and workforce
- **STEM Education**: Broadening participation, innovative pedagogy
- **Convergence Accelerators**: Use-inspired research with pathway to impact

## NSF Big Ideas and Special Initiatives

### NSF "Big Ideas"

1. **Harnessing the Data Revolution (HDR)**
2. **The Future of Work at the Human-Technology Frontier**
3. **Navigating the New Arctic**
4. **Windows on the Universe**
5. **The Quantum Leap**
6. **Understanding the Rules of Life**
7. **Mid-scale Research Infrastructure**

### Major NSF Initiatives

- **National AI Research Institutes**: $20M over 5 years per institute
- **Science and Technology Centers (STCs)**: Large-scale collaborative centers
- **Engineering Research Centers (ERCs)**: Engineering innovation ecosystems
- **Materials Research Science and Engineering Centers (MRSECs)**: Materials research
- **NSF Graduate Research Fellowship Program (GRFP)**: Student fellowships

## Tips for Competitive NSF Proposals

### Do's

✅ **Start with specific aims/objectives** - Crystal clear research goals
✅ **Make broader impacts substantive** - Specific activities, not platitudes
✅ **Use figures effectively** - Conceptual diagrams, preliminary data, timelines
✅ **Be realistic about scope** - Achievable within 3-5 years
✅ **Address both review criteria explicitly** - Don't make reviewers search
✅ **Get external feedback** - Mock review before submission
✅ **Follow formatting requirements exactly** - Auto-rejection for non-compliance
✅ **Explain jargon and acronyms** - Panel members may not be in your subfield
✅ **Integrate research and education** - Show natural connections
✅ **Demonstrate team qualifications** - Track record in proposed area

### Don'ts

❌ **Don't exceed page limits** - Automatic return without review
❌ **Don't use smaller fonts in figures** - Must be legible
❌ **Don't make broader impacts generic** - "Train students" is not enough
❌ **Don't ignore prior NSF support** - Must report if you've had NSF funding
❌ **Don't be overly ambitious** - Reviewers will see through unrealistic plans
❌ **Don't skip data management plan** - Required for all proposals
❌ **Don't forget biosketches for all personnel** - Common mistake
❌ **Don't submit at deadline** - Technical issues happen
❌ **Don't ignore program solicitation** - Requirements vary by program
❌ **Don't assume reviewers know your work** - Provide context

## Resources and Links

- **NSF Homepage**: https://www.nsf.gov
- **Award Search**: https://www.nsf.gov/awardsearch/
- **Proposal & Award Policies & Procedures Guide (PAPPG)**: https://www.nsf.gov/publications/pub_summ.jsp?ods_key=pappg
- **FastLane**: https://www.fastlane.nsf.gov/
- **Research.gov**: https://www.research.gov/
- **Broader Impacts Resources**: https://www.nsf.gov/od/oia/special/broaderimpacts/
- **NSF Funding Statistics**: https://www.nsf.gov/statistics/

---

**Key Takeaway**: NSF values both scientific excellence (Intellectual Merit) and societal benefit (Broader Impacts) equally. Successful proposals demonstrate innovative, feasible research that advances knowledge while contributing to education, diversity, infrastructure, or societal well-being in specific, measurable ways.

