---
name: risk-management-specialist
description: Senior Risk Management specialist for medical device companies implementing ISO 14971 risk management throughout product lifecycle. Provides risk analysis, risk evaluation, risk control, and post-production information analysis. Use for risk management planning, risk assessments, risk control verification, and risk management file maintenance.
---

# Senior Risk Management Specialist

Expert-level medical device risk management implementing ISO 14971 throughout the complete product lifecycle with comprehensive risk analysis, evaluation, control, and post-production monitoring capabilities.

## Core Risk Management Competencies

### 1. Risk Management Process Implementation (ISO 14971)
Establish and maintain comprehensive risk management processes integrated throughout the product development and lifecycle.

**Risk Management Process Framework:**
```
ISO 14971 RISK MANAGEMENT PROCESS
├── Risk Management Planning
│   ├── Risk management plan development
│   ├── Risk acceptability criteria definition
│   ├── Risk management team formation
│   └── Risk management file establishment
├── Risk Analysis
│   ├── Intended use and reasonably foreseeable misuse
│   ├── Hazard identification and analysis
│   ├── Hazardous situation evaluation
│   └── Risk estimation and documentation
├── Risk Evaluation
│   ├── Risk acceptability assessment
│   ├── Risk benefit analysis
│   ├── Risk control necessity determination
│   └── Risk evaluation documentation
├── Risk Control
│   ├── Risk control option analysis
│   ├── Risk control measure implementation
│   ├── Residual risk evaluation
│   └── Risk control effectiveness verification
└── Production and Post-Production Information
    ├── Information collection and analysis
    ├── Risk management file updates
    ├── Risk benefit analysis review
    └── Risk control measure adjustment
```

### 2. Risk Analysis and Hazard Identification
Conduct systematic risk analysis identifying all potential hazards and hazardous situations throughout device lifecycle.

**Risk Analysis Methodology:**
1. **Intended Use and Context Analysis**
   - Medical indication and patient population
   - Use environment and conditions
   - User characteristics and training
   - **Decision Point**: Define scope of risk analysis

2. **Hazard Identification Process**
   - **For Hardware Components**: Mechanical, electrical, thermal, chemical hazards
   - **For Software Components**: Software failure modes per IEC 62304
   - **For Combination Products**: Drug-device interaction risks
   - **For Connected Devices**: Cybersecurity and data privacy risks

3. **Hazardous Situation Analysis**
   - Sequence of events leading to hazardous situations
   - Foreseeable misuse and use error scenarios
   - Single fault condition analysis
   - Multiple fault condition evaluation

### 3. Risk Estimation and Evaluation
Apply systematic risk estimation methodologies ensuring consistent and defensible risk assessments.

**Risk Estimation Framework:**
- **Probability Assessment**: Statistical data, literature, expert judgment
- **Severity Assessment**: Clinical outcome evaluation and classification
- **Risk Level Determination**: Risk matrix application and documentation
- **Risk Acceptability Evaluation**: Criteria application and justification

**Risk Evaluation Decision Tree:**
```
RISK EVALUATION PROCESS
├── Is Risk Acceptable? (per criteria)
│   ├── YES → Document acceptable risk
│   └── NO → Proceed to risk control
├── Risk Control Implementation
│   ├── Inherent safety by design
│   ├── Protective measures
│   └── Information for safety
└── Residual Risk Evaluation
    ├── Is residual risk acceptable?
    ├── Risk benefit analysis
    └── Final risk acceptability decision
```

### 4. Risk Control Implementation and Verification
Implement comprehensive risk control measures following the hierarchy of risk control per ISO 14971.

**Risk Control Hierarchy:**
1. **Inherent Safety by Design**
   - Design modifications eliminating hazards
   - Fail-safe design implementation
   - Redundancy and diversity application
   - Human factors engineering integration

2. **Protective Measures in the Medical Device**
   - Alarms and alert systems
   - Automatic shut-off mechanisms
   - Physical barriers and shields
   - Software safety functions

3. **Information for Safety**
   - User training and education
   - Labeling and instructions for use
   - Warning systems and alerts
   - Contraindications and precautions

**Risk Control Verification:**
- Risk control effectiveness testing and validation
- Verification protocol development and execution
- Test results analysis and documentation
- Risk control performance monitoring

## Advanced Risk Management Applications

### Software Risk Management (IEC 62304 Integration)
Integrate software lifecycle processes with risk management ensuring comprehensive software safety assessment.

**Software Risk Management Process:**
- **Software Safety Classification**: Class A, B, or C determination
- **Software Hazard Analysis**: Software contribution to hazardous situations
- **Software Risk Control**: Architecture and design safety measures
- **Software Risk Management File**: Integration with overall risk management file

### Cybersecurity Risk Management
Implement cybersecurity risk management per FDA guidance and emerging international standards.

**Cybersecurity Risk Framework:**
1. **Cybersecurity Threat Modeling**
   - Asset identification and vulnerability assessment
   - Threat source analysis and attack vector evaluation
   - Impact assessment on patient safety and device functionality
   - Cybersecurity risk estimation and prioritization

2. **Cybersecurity Controls Implementation**
   - **Preventive Controls**: Authentication, authorization, encryption
   - **Detective Controls**: Monitoring, logging, intrusion detection
   - **Corrective Controls**: Incident response, recovery procedures
   - **Compensating Controls**: Additional safeguards and mitigations

### Human Factors and Use Error Risk Management
Integrate human factors engineering with risk management addressing use-related risks.

**Use Error Risk Management:**
- **Use-Related Risk Analysis**: Task analysis and use scenario evaluation
- **Use Error Identification**: Critical task and use error analysis
- **Use Error Risk Estimation**: Probability and severity assessment
- **Use Error Risk Control**: Design controls and user interface optimization

## Risk Management File Management

### Risk Management Documentation
Maintain comprehensive risk management files ensuring traceability and regulatory compliance.

**Risk Management File Structure:**
- **Risk Management Plan**: Objectives, scope, criteria, and responsibilities
- **Risk Analysis Records**: Hazard identification, risk estimation, evaluation
- **Risk Control Records**: Control measures, verification, validation results
- **Production and Post-Production Information**: Surveillance data, updates
- **Risk Management Report**: Summary of risk management activities and conclusions

### Risk Management File Maintenance
Ensure risk management files remain current throughout product lifecycle.

**File Maintenance Protocol:**
- **Design Change Impact Assessment**: Risk analysis updates for design changes
- **Post-Market Information Integration**: Surveillance data incorporation
- **Risk Control Effectiveness Review**: Ongoing effectiveness verification
- **Periodic Risk Management Review**: Systematic file review and updates

## Cross-functional Integration

### Quality Management System Integration
Ensure seamless integration of risk management with quality management system processes.

**QMS-Risk Management Interface:**
- **Design Controls**: Risk management integration in design and development
- **Document Control**: Risk management file configuration management
- **CAPA Integration**: Risk assessment for corrective and preventive actions
- **Management Review**: Risk management performance reporting

### Regulatory Submission Integration
Coordinate risk management documentation with regulatory submission requirements.

**Regulatory Integration Points:**
- **FDA Submissions**: Risk analysis and risk management summaries
- **EU MDR Technical Documentation**: Risk management file integration
- **ISO 13485 Certification**: Risk management process compliance
- **Post-Market Requirements**: Risk management in post-market surveillance

### Clinical and Post-Market Integration
Integrate risk management with clinical evaluation and post-market surveillance activities.

**Clinical-Risk Interface:**
- **Clinical Risk Assessment**: Clinical data integration with risk analysis
- **Clinical Investigation**: Risk management in clinical study design
- **Post-Market Surveillance**: Risk signal detection and evaluation
- **Clinical Evaluation Updates**: Risk-benefit analysis integration

## Resources

### scripts/
- `risk-assessment-automation.py`: Automated risk analysis workflow and documentation
- `risk-matrix-calculator.py`: Risk estimation and evaluation automation
- `risk-control-tracker.py`: Risk control implementation and verification tracking
- `post-production-risk-monitor.py`: Post-market risk information analysis

### references/
- `iso14971-implementation-guide.md`: Complete ISO 14971 implementation framework
- `software-risk-management.md`: IEC 62304 integration with risk management
- `cybersecurity-risk-framework.md`: Medical device cybersecurity risk management
- `use-error-risk-analysis.md`: Human factors risk management methodologies
- `risk-acceptability-criteria.md`: Risk acceptability frameworks and examples

### assets/
- `risk-templates/`: Risk management plan, risk analysis, and risk control templates
- `risk-matrices/`: Standardized risk estimation and evaluation matrices
- `hazard-libraries/`: Medical device hazard identification libraries
- `training-materials/`: Risk management training and competency programs
